/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.cms.attribute.decoder;

import de.intarsys.asn1.cms.attr.AttributeRevocationInfoArchival;
import de.intarsys.asn1.cms.attr.RevocationInfoArchival;
import de.intarsys.asn1.common.Attribute;
import de.intarsys.security.crl.IX509CRL;
import de.intarsys.security.crl.common.X509CRL;
import de.intarsys.security.ocsp.IOCSPResponse;
import de.intarsys.security.ocsp.common.OCSPResponse;
import de.intarsys.security.signature.attribute.IAttributeDecoder;
import de.intarsys.security.signature.attribute.IRevocationInfoArchivalAttribute;
import de.intarsys.security.signature.attribute.impl.RevocationInfoArchivalAttribute;
import java.io.IOException;
import java.security.cert.CRLException;
import java.util.ArrayList;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;

public class RevocationInfoArchivalDecoder
implements IAttributeDecoder {
    public IRevocationInfoArchivalAttribute decodeAttribute(Object srcAttribute) throws IOException {
        Attribute cmsAttribute = (Attribute)srcAttribute;
        AttributeRevocationInfoArchival attrRev = (AttributeRevocationInfoArchival)AttributeRevocationInfoArchival.FACTORY.create((ASN1Encodable)cmsAttribute);
        if (attrRev == null || attrRev.getRevocationInfoArchival() == null) {
            return null;
        }
        RevocationInfoArchival revocationInfoArchival = attrRev.getRevocationInfoArchival();
        IX509CRL[] crls = this.getCRLs(revocationInfoArchival);
        IOCSPResponse[] ocsps = this.getOCSPs(revocationInfoArchival);
        return new RevocationInfoArchivalAttribute(crls, ocsps);
    }

    private IX509CRL[] getCRLs(RevocationInfoArchival revocationInfoArchival) throws IOException {
        ArrayList<X509CRL> result = new ArrayList<X509CRL>();
        for (CertificateList certList : revocationInfoArchival.getCRLs()) {
            try {
                result.add(new X509CRL(certList));
            }
            catch (CRLException e) {
                throw new IOException(e.getLocalizedMessage(), e);
            }
        }
        return result.toArray(new IX509CRL[result.size()]);
    }

    private IOCSPResponse[] getOCSPs(RevocationInfoArchival revocationInfoArchival) {
        ArrayList<OCSPResponse> result = new ArrayList<OCSPResponse>();
        for (org.bouncycastle.asn1.ocsp.OCSPResponse ocspResponse : revocationInfoArchival.getOCSPs()) {
            if (ocspResponse.getResponseStatus().getValue().intValue() != 0) continue;
            byte[] encBasicOCSPResp = ocspResponse.getResponseBytes().getResponse().getOctets();
            result.add(new OCSPResponse(new BasicOCSPResp(BasicOCSPResponse.getInstance((Object)encBasicOCSPResp))));
        }
        return result.toArray(new IOCSPResponse[result.size()]);
    }

    public String getOID() {
        return "1.2.840.113583.1.1.8";
    }
}

