/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.processor.document.standard;

import de.intarsys.document.model.DocumentOutlet;
import de.intarsys.document.model.IDocumentType;
import de.intarsys.tools.component.SingletonProvider;
import de.intarsys.tools.file.PathTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.FunctorException;
import de.intarsys.tools.functor.FunctorTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.LocatorTools;
import de.intarsys.tools.servicelocator.ServiceLocator;
import de.intarsys.tools.tag.TagTools;
import java.io.IOException;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SingletonProvider
public class AttachmentResolver {
    private static final Logger Log = LoggerFactory.getLogger(AttachmentResolver.class);
    public static final String TAG_ATTACHMENT = "attachment";

    public static AttachmentResolver get() {
        return (AttachmentResolver)ServiceLocator.get().get(AttachmentResolver.class);
    }

    public ILocator getBaseLocator(ILocator attachementLocator) throws IOException {
        ILocator baseDocLocator = this.searchBaseDocument(attachementLocator);
        if (baseDocLocator == null) {
            baseDocLocator = this.requestLocator(attachementLocator);
        }
        return baseDocLocator;
    }

    private ILocator requestLocator(ILocator locator) {
        ILocator parentLocator = null;
        if (locator != null) {
            parentLocator = locator.getParent();
        }
        Args args = Args.createNamed((Object[])new Object[]{"directory", parentLocator});
        try {
            return (ILocator)FunctorTools.perform((Object)"de.intarsys.processor.document.standard.LoadSelectorFactory", (IArgs)args);
        }
        catch (FunctorException e) {
            Log.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private ILocator searchBaseDocument(ILocator locator) {
        ILocator dir = locator.getParent();
        if (dir == null) {
            return null;
        }
        String typedname = locator.getName().toLowerCase();
        String localname = LocatorTools.getBaseName((ILocator)locator).toLowerCase();
        try {
            ILocator[] docs = dir.listLocators((parent, name) -> {
                String elementName = name.toLowerCase();
                if (elementName.equals(typedname)) {
                    return false;
                }
                if (!elementName.startsWith(localname)) {
                    return false;
                }
                String elementSuffix = PathTools.getExtension((String)elementName).toLowerCase();
                IDocumentType elementType = DocumentOutlet.get().lookupDocumentTypeForExtension(elementSuffix);
                return elementType == null || !TagTools.hasTag((Object)elementType, (String)TAG_ATTACHMENT);
            });
            return Stream.of(docs).sorted((l1, l2) -> {
                if (l1.getName().toLowerCase().equals(localname)) {
                    return -1;
                }
                if (l2.getName().toLowerCase().equals(localname)) {
                    return 1;
                }
                return 0;
            }).findFirst().orElse(null);
        }
        catch (IOException e) {
            Log.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

