/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.common;

import de.intarsys.document.common.DocumentTools;
import de.intarsys.document.model.IDocumentType;
import de.intarsys.tools.file.PathTools;
import de.intarsys.tools.string.StringTools;
import jakarta.activation.FileTypeMap;
import jakarta.activation.MimetypesFileTypeMap;
import jakarta.annotation.PostConstruct;
import java.io.File;

public class DocumentFileTypeMap
extends FileTypeMap {
    private FileTypeMap baseMap;

    protected String basicGetContentType(String filename) {
        String extension = PathTools.getExtension((String)filename);
        if (StringTools.isEmpty((String)extension)) {
            return null;
        }
        IDocumentType documentType = DocumentTools.getDocumentTypeForExtension(extension);
        if (documentType == null) {
            return null;
        }
        return documentType.getDefaultMimeType();
    }

    public FileTypeMap getBaseMap() {
        return this.baseMap;
    }

    public String getContentType(File file) {
        return this.getContentType(file.getName());
    }

    public String getContentType(String filename) {
        String mimeType = this.basicGetContentType(filename);
        if (StringTools.isEmpty((String)mimeType)) {
            if (this.baseMap == null) {
                this.baseMap = new MimetypesFileTypeMap();
            }
            mimeType = this.baseMap.getContentType(filename);
        }
        return mimeType;
    }

    @PostConstruct
    public void install() {
        FileTypeMap.setDefaultFileTypeMap((FileTypeMap)this);
    }

    public void setBaseMap(FileTypeMap baseMap) {
        this.baseMap = baseMap;
    }
}

