/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.variable;

import de.intarsys.tools.bean.IBeanInstallationInstruction;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.string.StringTools;
import de.intarsys.tools.variable.IVariableNamespace;
import de.intarsys.tools.variable.IVariableNamespaces;
import de.intarsys.tools.variable.VariableNamespace;
import de.intarsys.tools.variable.VariableNamespaces;
import jakarta.annotation.PostConstruct;

public class Variable
implements IElementConfigurable,
IBeanInstallationInstruction {
    private String name;
    private String namespace;
    private String value;

    @Override
    public void configure(IElement element) throws ConfigurationException {
        this.setNamespace(element.attributeValue("namespace", this.getNamespace()));
        this.setName(element.attributeValue("name", this.getName()));
        this.setValue(element.attributeValue("value", this.getValue()));
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getValue() {
        return this.value;
    }

    @PostConstruct
    public void register() {
        if (StringTools.isEmpty(this.getNamespace())) {
            return;
        }
        if (StringTools.isEmpty(this.getName())) {
            return;
        }
        IVariableNamespaces namespaces = VariableNamespaces.get();
        IVariableNamespace myNamespace = namespaces.getNamespace(this.getNamespace());
        if (myNamespace instanceof VariableNamespace) {
            ((VariableNamespace)myNamespace).basicPutVariable(this.getName(), this.getValue());
        } else {
            myNamespace.putVariable(this.getName(), this.getValue());
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

