/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.state;

import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.message.IMessageBundleSupport;
import de.intarsys.tools.state.AtomicState;
import de.intarsys.tools.state.CommonState;
import de.intarsys.tools.state.ComplexState;
import de.intarsys.tools.state.IState;
import de.intarsys.tools.state.IStateHolder;
import java.util.List;

public class ConcurrentState
extends CommonState {
    public static final String DEFAULT_CONTEXT = "default";
    private final CommonState contextState;
    private final Object context;

    public static ConcurrentState create(CommonState state) {
        if (state instanceof ConcurrentState) {
            return (ConcurrentState)state;
        }
        return ConcurrentState.create((Object)DEFAULT_CONTEXT, state);
    }

    public static ConcurrentState create(Object context, CommonState state) {
        return new ConcurrentState(context, state);
    }

    public static ConcurrentState create(Object context, String id) {
        return new ConcurrentState(context, AtomicState.create(id));
    }

    public static ConcurrentState createDisposed(Object context) {
        return new ConcurrentState(context, AtomicState.DISPOSED);
    }

    public static ConcurrentState createFinal(Object context, String id) {
        return new ConcurrentState(context, AtomicState.createFinal(id));
    }

    public static ConcurrentState createInitial(Object context, String id) {
        return new ConcurrentState(context, AtomicState.createInitial(id));
    }

    protected ConcurrentState(Object context, CommonState pState) {
        this.context = context;
        this.contextState = pState;
    }

    @Override
    public IState attach(IStateHolder stateHolder) {
        return new ConcurrentState(this.context, (CommonState)this.contextState.attach(new ConcurrentStateHolder(stateHolder)));
    }

    protected String createLabel(IMessageBundle messageBundle, List<String> path) {
        if (this.contextState instanceof ComplexState) {
            return ((ComplexState)this.contextState).createLabel(messageBundle, path);
        }
        return this.getId();
    }

    @Override
    public void enterState(IState state) {
        this.contextState.enterState(state);
    }

    public Object getContext() {
        return this.context;
    }

    public IState getContextState() {
        return this.contextState;
    }

    @Override
    public String getId() {
        return this.contextState.getId();
    }

    @Override
    protected String getPrefix() {
        return "(c)";
    }

    @Override
    public IState getRootState() {
        return this.contextState.getRootState();
    }

    @Override
    public IState getState() {
        return this.contextState.getState();
    }

    @Override
    public boolean isAncestorOf(IState state) {
        return state.isAncestorOf(state);
    }

    @Override
    public boolean isFinal() {
        return this.contextState.isFinal();
    }

    @Override
    public boolean isInitial() {
        return this.contextState.isInitial();
    }

    class ConcurrentStateHolder
    implements IStateHolder,
    IMessageBundleSupport {
        private final IStateHolder stateHolder;

        public ConcurrentStateHolder(IStateHolder stateHolder) {
            this.stateHolder = stateHolder;
        }

        @Override
        public void enterState(IState ppState) {
            ConcurrentState result = new ConcurrentState(ConcurrentState.this.getContext(), (CommonState)ppState);
            this.getStateHolder().enterState(result);
        }

        @Override
        public IMessageBundle getMessageBundle() {
            if (this.getStateHolder() instanceof IMessageBundleSupport) {
                return ((IMessageBundleSupport)((Object)this.getStateHolder())).getMessageBundle();
            }
            return null;
        }

        @Override
        public IState getState() {
            return this.getStateHolder().getState();
        }

        public IStateHolder getStateHolder() {
            return this.stateHolder;
        }
    }
}

