/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.monitor;

import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.monitor.AbstractMonitorTrace;
import de.intarsys.tools.monitor.IMonitor;
import de.intarsys.tools.monitor.ITrace;
import de.intarsys.tools.monitor.Trace;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public abstract class AbstractMonitor
implements IMonitor,
IElementConfigurable {
    private static final int LOG_CYCLE = 100;
    private static final String ATTR_LEVEL = "level";
    private static final String ATTR_LOGGER = "logger";
    private static final String ATTR_COLLECT_COUNT = "collect.count";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_LOGCYCLE = "logcycle";
    private static Level DefaultLevel = Level.INFO;
    private String name;
    private Logger logger;
    private Level level = DefaultLevel;
    private LinkedList traces = new LinkedList();
    private int collectAll;
    private int logCycle = 100;
    private int traceCount;
    private final ThreadLocal<AbstractMonitorTrace> tracePerThread = ThreadLocal.withInitial(() -> this.createMonitorTrace());

    public static Level getDefaultLevel() {
        return DefaultLevel;
    }

    public static void setDefaultLevel(Level defaultLevel) {
        DefaultLevel = defaultLevel;
    }

    protected AbstractMonitor() {
        this("");
    }

    protected AbstractMonitor(String name) {
        this.name = name;
        this.logger = LoggerFactory.getLogger((String)name);
    }

    @Override
    public final ITrace attach() {
        AbstractMonitorTrace trace = (AbstractMonitorTrace)this.getCurrentTrace();
        trace.start();
        Trace.registerTrace(trace);
        return trace;
    }

    @Override
    public void configure(IElement element) throws ConfigurationException {
        Level newLevel;
        this.setName(ElementTools.getPathString(element, ATTR_NAME, ""));
        this.setCollectAll(ElementTools.getPathInt(element, ATTR_COLLECT_COUNT, 0));
        String loggerString = ElementTools.getPathString(element, ATTR_LOGGER, this.getName());
        if (loggerString != null) {
            this.setLogger(LoggerFactory.getLogger((String)loggerString));
        }
        String defaultLevelString = DefaultLevel.toString();
        String levelString = ElementTools.getPathString(element, ATTR_LEVEL, defaultLevelString);
        try {
            newLevel = Level.valueOf((String)levelString);
        }
        catch (Exception e) {
            newLevel = Level.INFO;
        }
        this.setLevel(newLevel);
        int intValue = ElementTools.getPathInt(element, ATTR_LOGCYCLE, 100);
        this.setLogCycle(intValue);
    }

    protected abstract AbstractMonitorTrace createMonitorTrace();

    @Override
    public final void detach() {
        AbstractMonitorTrace trace = (AbstractMonitorTrace)this.getCurrentTrace();
        trace.stop();
    }

    protected LinkedList getBasicTraces() {
        return this.traces;
    }

    public int getCollectAll() {
        return this.collectAll;
    }

    @Override
    public ITrace getCurrentTrace() {
        return this.tracePerThread.get();
    }

    public Level getLevel() {
        return this.level;
    }

    public int getLogCycle() {
        return this.logCycle;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public synchronized List getTraces() {
        ArrayList list = new ArrayList(this.traces);
        return list;
    }

    @Override
    public void reset() {
        this.traceLog();
        this.traces = new LinkedList();
        this.traceCount = 0;
    }

    public void setCollectAll(int count) {
        this.collectAll = count;
    }

    public void setLevel(Level traceLogLevel) {
        this.level = traceLogLevel;
    }

    public void setLogCycle(int pLogCycle) {
        this.logCycle = pLogCycle;
    }

    public void setLogger(Logger traceLog) {
        this.logger = traceLog;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Deprecated
    public void start() {
        this.attach();
    }

    protected synchronized void started(ITrace trace) {
    }

    @Deprecated
    public void stop() {
        this.detach();
    }

    protected synchronized void stopped(ITrace trace) {
        Trace.unregisterTrace(trace);
        if (this.getCollectAll() > 0) {
            this.getBasicTraces().add(trace);
            this.tracePerThread.set(this.createMonitorTrace());
            if (this.getCollectAll() < this.getBasicTraces().size()) {
                this.getBasicTraces().removeFirst();
            }
        }
        ++this.traceCount;
        if (this.getLogCycle() != -1 && this.traceCount >= this.getLogCycle()) {
            this.reset();
        }
    }

    protected void traceLog() {
        if (this.getLogger() != null) {
            this.getLogger().atLevel(this.getLevel()).log(this.toString());
        }
    }
}

