/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.file.TempTools;
import de.intarsys.tools.locator.AbstractLocator;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.LocatorTools;
import java.io.File;
import java.io.IOException;

public abstract class CommonLocator
extends AbstractLocator {
    static final long serialVersionUID = 1L;

    protected ILocator createTempFileLocator() throws IOException {
        File file = TempTools.createTempFile("locator", ".tmp");
        file.deleteOnExit();
        FileLocator tempFileLocator = new FileLocator(file);
        LocatorTools.copy(this, tempFileLocator);
        tempFileLocator.setReadOnly();
        return tempFileLocator;
    }

    @Override
    public void delete() throws IOException {
        this.throwUnsupported();
    }

    @Override
    public long getLength() throws IOException {
        return -1L;
    }

    @Override
    public void rename(String newName) throws IOException {
        this.throwUnsupported();
    }

    protected void throwReadOnly() throws IOException {
        throw new IOException("read only");
    }

    protected void throwUnsupported() throws IOException {
        throw new IOException("unsupported operation");
    }
}

