/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.ipc;

import de.intarsys.tools.collection.ConversionIterator;
import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.ConverterRegistry;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.ipc.IIPCScope;
import de.intarsys.tools.ipc.IPCHandle;
import de.intarsys.tools.ipc.IPCObject;
import de.intarsys.tools.ipc.IPCScope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class IPCMarshaller {
    protected IIPCScope getScope() {
        return IPCScope.get();
    }

    public Object marshal(Object value) throws IOException {
        if (value instanceof IArgs) {
            return this.marshalArgs((IArgs)value);
        }
        if (value instanceof Map) {
            return this.marshalMap((Map)value);
        }
        if (value instanceof Object[]) {
            return this.marshalArray((Object[])value);
        }
        if (value instanceof Collection) {
            return this.marshalCollection((Collection)value);
        }
        if (value instanceof Iterator) {
            return this.marshalIterator((Iterator)value);
        }
        try {
            value = ConverterRegistry.get().convert(value, IPCObject.class);
        }
        catch (ConversionException e) {
            throw new IOException(e);
        }
        return value;
    }

    protected Object marshalArgs(IArgs args) throws IOException {
        Args tempCopy = Args.create();
        boolean touched = false;
        Iterator<IArgs.IBinding> it = args.bindings();
        while (it.hasNext()) {
            IArgs.IBinding binding = it.next();
            String name = binding.getName();
            Object value = binding.getValue();
            Object newValue = this.marshal(value);
            tempCopy.add(newValue).setName(name);
            if (newValue == value) continue;
            touched = true;
        }
        return touched ? tempCopy : args;
    }

    protected Object marshalArray(Object[] array) throws IOException {
        Object[] tempCopy = new Object[array.length];
        boolean touched = false;
        for (int i = 0; i < array.length; ++i) {
            Object newValue;
            Object value = array[i];
            tempCopy[i] = newValue = this.marshal(value);
            if (newValue == value) continue;
            touched = true;
        }
        return touched ? tempCopy : array;
    }

    protected Object marshalCollection(Collection collection) throws IOException {
        ArrayList<Object> tempCopy = new ArrayList<Object>(collection.size());
        boolean touched = false;
        for (Object value : collection) {
            Object newValue = this.marshal(value);
            tempCopy.add(newValue);
            if (newValue == value) continue;
            touched = true;
        }
        return touched ? tempCopy : collection;
    }

    protected Object marshalIterator(Iterator iterator) {
        final IIPCScope deferredScope = this.getScope();
        return new ConversionIterator(iterator){

            protected Object createTargetObject(Object sourceObject) {
                IIPCScope currentScope = IPCScope.lookup();
                try {
                    IPCScope.set(deferredScope);
                    Object object = IPCMarshaller.this.marshal(sourceObject);
                    return object;
                }
                catch (IOException e) {
                    throw ExceptionTools.wrap(e);
                }
                finally {
                    IPCScope.set(currentScope);
                }
            }
        };
    }

    @Deprecated
    public Object marshall(Object value) throws IOException {
        return this.marshal(value);
    }

    protected Object marshalMap(Map map) throws IOException {
        HashMap tempCopy = new HashMap(map.size());
        boolean touched = false;
        for (Map.Entry entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            Object newValue = this.marshal(value);
            tempCopy.put(key, newValue);
            if (newValue == value) continue;
            touched = true;
        }
        return touched ? tempCopy : map;
    }

    public Object unmarshal(Object value) throws IOException {
        if (value instanceof IArgs) {
            return this.unmarshalArgs((IArgs)value);
        }
        if (value instanceof Map) {
            return this.unmarshalMap((Map)value);
        }
        if (value instanceof Object[]) {
            return this.unmarshalArray((Object[])value);
        }
        if (value instanceof Collection) {
            return this.unmarshalCollection((Collection)value);
        }
        if (value instanceof Iterator) {
            return this.unmarshalIterator((Iterator)value);
        }
        if (value instanceof String) {
            return this.unmarshalString((String)value);
        }
        return value;
    }

    protected Object unmarshalArgs(IArgs args) throws IOException {
        Iterator<IArgs.IBinding> it = args.bindings();
        while (it.hasNext()) {
            IArgs.IBinding binding = it.next();
            Object value = binding.getValue();
            Object newValue = this.unmarshal(value);
            binding.setValue(newValue);
        }
        return args;
    }

    protected Object unmarshalArray(Object[] array) throws IOException {
        Object[] tempCopy = new Object[array.length];
        boolean touched = false;
        for (int i = 0; i < array.length; ++i) {
            Object newValue;
            Object value = array[i];
            tempCopy[i] = newValue = this.unmarshal(value);
            if (newValue == value) continue;
            touched = true;
        }
        return touched ? tempCopy : array;
    }

    protected Object unmarshalCollection(Collection collection) throws IOException {
        ArrayList<Object> tempCopy = new ArrayList<Object>(collection.size());
        boolean touched = false;
        for (Object value : collection) {
            Object newValue = this.unmarshal(value);
            tempCopy.add(newValue);
            if (newValue == value) continue;
            touched = true;
        }
        return touched ? tempCopy : collection;
    }

    protected Object unmarshalIterator(Iterator iterator) {
        return new ConversionIterator(iterator){

            protected Object createTargetObject(Object sourceObject) {
                try {
                    return IPCMarshaller.this.unmarshal(sourceObject);
                }
                catch (IOException e) {
                    throw ExceptionTools.wrap(e);
                }
            }
        };
    }

    @Deprecated
    public Object unmarshall(Object value) throws IOException {
        return this.unmarshal(value);
    }

    protected Object unmarshalMap(Map map) throws IOException {
        HashMap tempCopy = new HashMap(map.size());
        boolean touched = false;
        for (Map.Entry entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            Object newValue = this.unmarshal(value);
            tempCopy.put(key, newValue);
            if (newValue == value) continue;
            touched = true;
        }
        return touched ? tempCopy : map;
    }

    protected Object unmarshalString(String value) throws IOException {
        String tempString = value;
        if (tempString.startsWith("ipc://")) {
            try {
                IPCHandle handle = this.getScope().importHandle(tempString);
                if (handle.isResolved()) {
                    return handle.getObject();
                }
                return handle;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        return value;
    }
}

