/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.expression;

import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.functor.IArgs;
import java.util.Map;
import java.util.function.UnaryOperator;

public class AliasResolver
implements IStringEvaluator {
    private IStringEvaluator delegate;
    private UnaryOperator<String> resolver;

    public AliasResolver(IStringEvaluator delegate, Map<String, String> aliases) {
        this(delegate, Map.copyOf(aliases)::get);
    }

    public AliasResolver(IStringEvaluator delegate, UnaryOperator<String> resolver) {
        this.delegate = delegate;
        this.resolver = resolver;
    }

    @Override
    public Object evaluate(String expression, IArgs args) throws EvaluationException {
        String alias = this.resolveAliases(expression);
        if (alias == null) {
            return this.delegate.evaluate(expression, args);
        }
        try {
            return this.delegate.evaluate(alias, args);
        }
        catch (EvaluationException exception) {
            throw new EvaluationException(String.format("Could not evaluate alias: %s -> %s", expression, alias), exception);
        }
    }

    private String resolveAliases(String expression) {
        int headLength = expression.length();
        while (headLength > 0) {
            String head = expression.substring(0, headLength);
            String alias = (String)this.resolver.apply(head);
            if (alias != null && !alias.equals(head)) {
                return alias + expression.substring(headLength);
            }
            headLength = expression.lastIndexOf(46, headLength - 1);
        }
        return null;
    }
}

