/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.crypto;

import de.intarsys.tools.crypto.ICryptdec;
import de.intarsys.tools.crypto.PBCryptdecFactory;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.crypto.StaticCryptdec;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class PBAES128CryptdecFactory
extends PBCryptdecFactory {
    private byte[] initializationVector;
    private Secret password;
    private byte[] salt;
    private int iterationCount;
    private SecretKey key;

    public PBAES128CryptdecFactory(String id, byte[] iv, Secret password, byte[] salt, int iterationCount) throws GeneralSecurityException {
        super(id);
        this.initializationVector = Arrays.copyOf(iv, iv.length);
        this.password = password;
        this.salt = Arrays.copyOf(salt, salt.length);
        this.iterationCount = iterationCount;
        this.init();
    }

    @Override
    public ICryptdec createCryptdec() throws GeneralSecurityException {
        Cipher ecipher = Cipher.getInstance(this.getCipherId());
        Cipher dcipher = Cipher.getInstance(this.getCipherId());
        IvParameterSpec ips = new IvParameterSpec(this.getInitializationVector());
        ecipher.init(1, (Key)this.getKey(), ips);
        dcipher.init(2, (Key)this.getKey(), ips);
        return new StaticCryptdec(this.getId(), ecipher, dcipher);
    }

    protected String getCipherAlgorithmId() {
        return "AES";
    }

    protected String getCipherId() {
        return "AES/CBC/PKCS5Padding";
    }

    public byte[] getInitializationVector() {
        return this.initializationVector;
    }

    public int getIterationCount() {
        return this.iterationCount;
    }

    private SecretKey getKey() {
        return this.key;
    }

    protected int getKeyLength() {
        return 128;
    }

    protected Secret getPassword() {
        return this.password;
    }

    protected String getPBKeyFactoryId() {
        return "PBKDF2WithHmacSHA1";
    }

    public byte[] getSalt() {
        return this.salt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws GeneralSecurityException {
        SecretKeyFactory pbKeyFactory = SecretKeyFactory.getInstance(this.getPBKeyFactoryId());
        PBEKeySpec pbKeySpec = new PBEKeySpec(this.password.getChars(), this.salt, this.iterationCount, this.getKeyLength());
        try {
            SecretKey pbSecret = pbKeyFactory.generateSecret(pbKeySpec);
            this.key = new SecretKeySpec(pbSecret.getEncoded(), this.getCipherAlgorithmId());
        }
        finally {
            pbKeySpec.clearPassword();
        }
    }
}

