/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.authenticate;

import de.intarsys.tools.collection.ByteArrayTools;
import de.intarsys.tools.crypto.CryptoTools;
import de.intarsys.tools.encoding.Base64;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public final class PasswordTools {
    public static final String CHARS_ADDITION = "!$%&/=?*+#-_";
    public static final String CHARS_DIGITS = "0123456879";
    public static final String CHARS_LOWERCASE = "abcdefghijklmnopqrstuvwxyz";
    public static final String CHARS_UPPERCASE = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String CHARS = "0123456879abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ!$%&/=?*+#-_";

    public static char[] createPassword(int length) {
        return PasswordTools.createPassword(length, CHARS);
    }

    public static char[] createPassword(int length, String valid) {
        SecureRandom srand = CryptoTools.createSecureRandom();
        char[] buff = new char[length];
        int size = valid.length();
        for (int i = 0; i < length; ++i) {
            buff[i] = valid.charAt(srand.nextInt(size));
        }
        return buff;
    }

    public static String createSalt(int length) {
        byte[] saltBytes = ByteArrayTools.createRandomBytes(length);
        return new String(Base64.encode(saltBytes));
    }

    public static String hash(String salt, char[] password) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("missing SHA-1 hash");
        }
        if (!StringTools.isEmpty(salt)) {
            try {
                md.update(Base64.decode(salt));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("invalid salt");
            }
        }
        md.update(new String(password).getBytes(StandardCharsets.UTF_8));
        byte[] raw = md.digest();
        return new String(Base64.encode(raw));
    }

    private PasswordTools() {
    }
}

