/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.x509.crl;

import de.intarsys.asn1.common.AlgorithmIdentifier;
import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.x509.crl.TBSCertList;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERBitString;

public class CertificateList
extends ASN1Based {
    public static final Factory FACTORY = new Factory();

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return (AlgorithmIdentifier)AlgorithmIdentifier.FACTORY.create(this.getValueHolder().getChild(1));
    }

    public byte[] getSignatureValue() {
        return this.getValueHolder().getChild(2).toDERBitString().getBytes();
    }

    public TBSCertList getTBSCertList() {
        return (TBSCertList)TBSCertList.FACTORY.create(this.getValueHolder().getChild(0));
    }

    public void setSignatureAlgorithm(AlgorithmIdentifier signatureAlgo) {
        this.getValueHolder().setChild(1, signatureAlgo);
    }

    public void setSignatureValue(byte[] signatureValue) {
        this.getValueHolder().setChild(2, (ASN1Encodable)new DERBitString(signatureValue));
    }

    public void setTBSCertList(TBSCertList tbsCertList) {
        this.getValueHolder().setChild(0, tbsCertList);
    }

    public static class Factory
    extends ASN1Based.Factory<CertificateList> {
    }
}

