/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.common;

import de.intarsys.asn1.common.AttributeAny;
import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1SetHolder;
import de.intarsys.asn1.model.ASN1ValueHolder;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;

public abstract class Attribute
extends ASN1Based {
    public void addAttrValue(ASN1Encodable value) {
        ASN1ValueHolder seq = this.getOrCreateAttrValue();
        seq.addChild(value);
    }

    public void clearAttrValue() {
        if (this.getValueHolder().size() < 2) {
            return;
        }
        this.getValueHolder().setChild(1, null);
    }

    public Attribute copy() throws IOException {
        return (Attribute)AttributeAny.FACTORY.create((ASN1Encodable)this.basicCopy());
    }

    public String getAttrType() {
        ASN1ValueHolder o = this.getValueHolder().getChild(0);
        if (o != null) {
            return o.toDERObjectIdentifier().getId();
        }
        return null;
    }

    public ASN1ValueHolder getAttrValue(int index) {
        ASN1ValueHolder seq = this.getAttrValues();
        if (seq != null) {
            return seq.getChild(index);
        }
        return null;
    }

    protected ASN1ValueHolder getAttrValues() {
        return this.getValueHolder().getChild(1);
    }

    private ASN1ValueHolder getOrCreateAttrValue() {
        ASN1ValueHolder seq = this.getAttrValues();
        if (seq == null) {
            seq = new ASN1SetHolder();
            this.getValueHolder().setChild(1, seq);
        }
        return seq;
    }

    public void setAttrType(String typeId) {
        this.getValueHolder().setChild(0, (ASN1Encodable)new ASN1ObjectIdentifier(typeId));
    }

    public void setAttrValue(int index, ASN1Encodable value) {
        ASN1ValueHolder seq = this.getOrCreateAttrValue();
        seq.setChild(index, value);
    }

    @Override
    public int size() {
        ASN1ValueHolder seq = this.getAttrValues();
        if (seq != null) {
            return seq.size();
        }
        return 0;
    }

    public static abstract class Factory<T extends Attribute>
    extends ASN1Based.Factory<T> {
        public abstract String getAttributeType();
    }
}

