/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.cms;

import de.intarsys.asn1.cms.SignerInfo;
import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1SetHolder;
import de.intarsys.asn1.model.ASN1ValueHolder;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;

public class SignerInfos
extends ASN1Based {
    public static final Factory FACTORY = new Factory();

    public void add(SignerInfo signerInfo) {
        this.getValueHolder().addChild(signerInfo);
    }

    public SignerInfos copy() throws IOException {
        return (SignerInfos)FACTORY.create((ASN1Encodable)this.basicCopy());
    }

    public SignerInfo get(int index) {
        return (SignerInfo)SignerInfo.FACTORY.create(this.getValueHolder().getChild(index));
    }

    public boolean isAnySignerInfoVersion(int version) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            SignerInfo signer = this.get(i);
            if (signer.getVersion().getIntValue() < version) continue;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.getValueHolder().size();
    }

    public static class Factory
    extends ASN1Based.Factory<SignerInfos> {
        @Override
        protected ASN1ValueHolder basicCreateValueHolder() {
            return new ASN1SetHolder();
        }
    }
}

