/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.cms;

import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1ScalarHolder;
import de.intarsys.asn1.model.ASN1ValueHolder;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;

public class SignatureValue
extends ASN1Based {
    public static final Factory FACTORY = new Factory();

    public static SignatureValue create(byte[] signature) {
        SignatureValue result = (SignatureValue)FACTORY.createNew();
        result.setBytes(signature);
        return result;
    }

    public SignatureValue copy() throws IOException {
        return (SignatureValue)FACTORY.create((ASN1Encodable)this.basicCopy());
    }

    public byte[] getBytes() {
        return this.getValueHolder().toDEROctetString().getOctets();
    }

    public void setBytes(byte[] signature) {
        this.getValueHolder().setValue((ASN1Primitive)new DEROctetString(signature));
    }

    public static class Factory
    extends ASN1Based.Factory<SignatureValue> {
        @Override
        protected ASN1ValueHolder basicCreateValueHolder() {
            return new ASN1ScalarHolder();
        }
    }
}

