/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.cms;

import de.intarsys.asn1.cms.KeyAgreeRecipientInfo;
import de.intarsys.asn1.cms.KeyTransRecipientInfo;
import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1TaggedHolder;

public class RecipientInfo
extends ASN1Based {
    public static final Factory FACTORY = new Factory();

    public KeyAgreeRecipientInfo getKeyAgreeRecipientInfo() {
        if (!this.isKeyAgreeRecipientInfo()) {
            return null;
        }
        return (KeyAgreeRecipientInfo)KeyAgreeRecipientInfo.FACTORY.create(((ASN1TaggedHolder)this.getValueHolder()).getChild());
    }

    public KeyTransRecipientInfo getKeyTransRecipientInfo() {
        if (!this.isKeyTransRecipientInfo()) {
            return null;
        }
        return (KeyTransRecipientInfo)KeyTransRecipientInfo.FACTORY.create(this.getValueHolder());
    }

    public boolean isKEKRecipientInfo() {
        if (!this.getValueHolder().isTagged()) {
            return false;
        }
        return ((ASN1TaggedHolder)this.getValueHolder()).getTagNo() == 2;
    }

    public boolean isKeyAgreeRecipientInfo() {
        if (!this.getValueHolder().isTagged()) {
            return false;
        }
        return ((ASN1TaggedHolder)this.getValueHolder()).getTagNo() == 1;
    }

    public boolean isKeyTransRecipientInfo() {
        return !this.getValueHolder().isTagged();
    }

    public boolean isOtherRecipientInfo() {
        if (!this.getValueHolder().isTagged()) {
            return false;
        }
        return ((ASN1TaggedHolder)this.getValueHolder()).getTagNo() == 4;
    }

    public boolean isPasswordRecipientInfo() {
        if (!this.getValueHolder().isTagged()) {
            return false;
        }
        return ((ASN1TaggedHolder)this.getValueHolder()).getTagNo() == 3;
    }

    public void setKeyAgreeRecipientInfo(KeyAgreeRecipientInfo keyAgreeRecipientInfo) {
        this.setValueHolder(new ASN1TaggedHolder(true, 1, keyAgreeRecipientInfo));
    }

    public void setKeyTransRecipientInfo(KeyTransRecipientInfo keyTransRecipientInfo) {
        this.setValueHolder(keyTransRecipientInfo.getValueHolder());
    }

    public static class Factory
    extends ASN1Based.Factory<RecipientInfo> {
    }
}

