/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.http.content;

import de.intarsys.tools.http.content.HttpEntityMultipartFormDataEncoder;
import de.intarsys.tools.serialize.BONSerializationFactory;
import de.intarsys.tools.serialize.ISerializationFactory;
import de.intarsys.tools.serialize.ISerializer;
import de.intarsys.tools.serialize.SerializationContext;
import de.intarsys.tools.serialize.StreamSerializationContext;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;

public class HttpEntityMultipartFormDataWithIntarsysPrimitiveEncoder
extends HttpEntityMultipartFormDataEncoder {
    private static final ISerializationFactory FACTORY = new BONSerializationFactory();

    @Override
    protected ContentBody createEntityStringBody(MultipartEntity entity, Object value) throws IOException {
        String serialized = this.serialize(value);
        Charset charset = StandardCharsets.UTF_8;
        String mimeType = "application/vnd.intarsys.primitive";
        return new StringBody(serialized, mimeType, charset);
    }

    @Override
    protected String serialize(Object value) throws IOException {
        StreamSerializationContext context = new StreamSerializationContext();
        ISerializer serializer = FACTORY.createSerializer((SerializationContext)context);
        serializer.serialize(value);
        return new String(context.getBytes(), StandardCharsets.UTF_8);
    }
}

