/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.audit.v2.table;

import de.intarsys.security.audit.v2.core.Audit;
import de.intarsys.security.audit.v2.core.AuditException;
import de.intarsys.security.audit.v2.core.IAuditEntry;
import de.intarsys.security.audit.v2.core.IAuditSession;
import de.intarsys.security.audit.v2.core.IAuditSignatureProvider;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.infoset.ElementSerializationException;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.string.StringTools;
import de.intarsys.tools.table.ITableColumn;
import de.intarsys.tools.table.ITableRecord;
import de.intarsys.tools.table.ITableType;
import de.intarsys.tools.table.TableColumn;
import de.intarsys.tools.table.TableProcessingException;
import de.intarsys.tools.table.TableProcessor;
import java.util.ArrayList;
import java.util.List;

public class TableProcessorAudit<R>
extends TableProcessor<R> {
    private static final int DELAY = 1;
    private final TableColumn colTick;
    private final TableColumn colSequenceNumber;
    private final TableColumn colCommand;
    private final TableColumn colSeal;
    private IAuditSession auditSession;
    private Audit audit;
    private AuditType auditType;
    private final Object lock = new Object();

    public TableProcessorAudit() {
        this.colCommand = new TableColumn("auditCommand");
        this.colTick = new TableColumn("auditTick");
        this.colSequenceNumber = new TableColumn("auditSequenceNumber");
        this.colSeal = new TableColumn("auditSeal");
        Audit tmpAudit = Audit.createNew();
        tmpAudit.setHeartbeatInterval(1);
        this.setAudit(tmpAudit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws TableProcessingException {
        try {
            Object object = this.lock;
            synchronized (object) {
                AuditRecord auditRecord = this.createCloseRecord();
                this.getChainedProcessor().process((ITableRecord)auditRecord);
                AuditRecord signatureRecord = this.createSignatureRecord();
                if (signatureRecord != null) {
                    this.getChainedProcessor().process((ITableRecord)signatureRecord);
                }
            }
            this.auditType = null;
            this.setSession(null);
        }
        catch (AuditException e) {
            throw new TableProcessingException((Throwable)e);
        }
        super.close();
    }

    public void configure(IElement element) throws ConfigurationException {
        super.configure(element);
        IElement elAudit = element.element("audit");
        if (elAudit != null) {
            this.getAudit().configure(elAudit);
        }
    }

    protected AuditRecord createCloseRecord() throws TableProcessingException, AuditException {
        IAuditEntry entry = this.getAuditSession().close();
        AuditRecord auditRecord = (AuditRecord)this.getAuditType().createRecord();
        auditRecord.setAuditCommand(entry.getAuditCommand());
        auditRecord.setAuditSeal(entry.getAuditSeal());
        auditRecord.setAuditSequenceNumber(entry.getAuditSequenceNumber());
        auditRecord.setAuditTick(entry.getAuditTick());
        return auditRecord;
    }

    protected AuditRecord createFirstRecord() throws TableProcessingException, AuditException {
        IAuditEntry entry = this.getAuditSession().open();
        AuditRecord auditRecord = (AuditRecord)this.getAuditType().createRecord();
        auditRecord.setAuditCommand(entry.getAuditCommand());
        auditRecord.setAuditSeal(entry.getAuditSeal());
        auditRecord.setAuditSequenceNumber(entry.getAuditSequenceNumber());
        auditRecord.setAuditTick(entry.getAuditTick());
        return auditRecord;
    }

    protected AuditRecord createSignatureRecord() throws TableProcessingException, AuditException {
        IAuditEntry entry = this.getAuditSession().sign();
        if (entry != null) {
            AuditRecord auditRecord = (AuditRecord)this.getAuditType().createRecord();
            auditRecord.setAuditCommand(entry.getAuditCommand());
            auditRecord.setAuditSeal(entry.getAuditSeal());
            auditRecord.setAuditSequenceNumber(entry.getAuditSequenceNumber());
            auditRecord.setAuditTick(entry.getAuditTick());
            return auditRecord;
        }
        return null;
    }

    protected Audit getAudit() {
        return this.audit;
    }

    protected IAuditSession getAuditSession() {
        return this.auditSession;
    }

    public AuditType getAuditType() {
        return this.auditType;
    }

    protected ITableType getChainedType() {
        return this.auditType;
    }

    public IAuditSignatureProvider getSignatureProvider() {
        return this.getAudit().getSignatureProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(ITableType type) throws TableProcessingException {
        try {
            this.auditType = new AuditType(type);
            this.setSession(this.getAudit().createSession());
            super.open(type);
            Object object = this.lock;
            synchronized (object) {
                AuditRecord firstRecord = this.createFirstRecord();
                this.getChainedProcessor().process((ITableRecord)firstRecord);
                AuditRecord signatureRecord = this.createSignatureRecord();
                if (signatureRecord != null) {
                    this.getChainedProcessor().process((ITableRecord)signatureRecord);
                }
            }
        }
        catch (Exception e) {
            throw new TableProcessingException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R process(ITableRecord tableRecord) throws TableProcessingException {
        try {
            Object object = this.lock;
            synchronized (object) {
                AuditRecord auditRecord = new AuditRecord(tableRecord);
                IAuditEntry entry = this.getAuditSession().log(auditRecord.getAuditMessage());
                auditRecord.setAuditCommand(entry.getAuditCommand());
                auditRecord.setAuditSeal(entry.getAuditSeal());
                auditRecord.setAuditSequenceNumber(entry.getAuditSequenceNumber());
                auditRecord.setAuditTick(entry.getAuditTick());
                return (R)this.getChainedProcessor().process((ITableRecord)auditRecord);
            }
        }
        catch (Exception e) {
            throw new TableProcessingException((Throwable)e);
        }
    }

    public void serialize(IElement element) throws ElementSerializationException {
        super.serialize(element);
        IElement elAudit = element.newElementMapped("audit");
        this.getAudit().serialize(elAudit);
    }

    protected void setAudit(Audit audit) {
        this.audit = audit;
    }

    protected void setSession(IAuditSession session) {
        this.auditSession = session;
    }

    public void setSignatureProvider(IAuditSignatureProvider provider) {
        this.getAudit().setSignatureProvider(provider);
    }

    class AuditRecord
    implements ITableRecord {
        private final ITableRecord item;
        private final String message;

        public AuditRecord(ITableRecord item) {
            this.item = item;
            this.message = this.createMessage(item);
        }

        protected String createMessage(ITableRecord item) {
            StringBuilder sb = new StringBuilder();
            for (ITableColumn column : TableProcessorAudit.this.getActiveType().getColumns()) {
                if (sb.length() > 0) {
                    sb.append(";");
                }
                Object value = item.get(column.getName(), null);
                sb.append(StringTools.safeString((Object)value));
            }
            return sb.toString();
        }

        public Object get(String path, Object defaultValue) {
            return this.item.get(path, defaultValue);
        }

        public char getAuditCommand() {
            return ((Character)this.item.get(TableProcessorAudit.this.colCommand.getName(), (Object)Character.valueOf(' '))).charValue();
        }

        public String getAuditMessage() {
            return this.message;
        }

        public byte[] getAuditSeal() {
            return (byte[])this.item.get(TableProcessorAudit.this.colSeal.getName(), null);
        }

        public int getAuditSequenceNumber() {
            return (Integer)this.item.get(TableProcessorAudit.this.colSequenceNumber.getName(), (Object)0);
        }

        public long getAuditTick() {
            return (Long)this.item.get(TableProcessorAudit.this.colTick.getName(), (Object)0);
        }

        public ITableType getType() {
            return TableProcessorAudit.this.auditType;
        }

        public void put(String path, Object value) {
            throw new IllegalStateException();
        }

        public void setAuditCommand(char value) {
            this.item.put(TableProcessorAudit.this.colCommand.getName(), (Object)Character.valueOf(value));
        }

        public void setAuditSeal(byte[] value) {
            this.item.put(TableProcessorAudit.this.colSeal.getName(), (Object)value);
        }

        public void setAuditSequenceNumber(int value) {
            this.item.put(TableProcessorAudit.this.colSequenceNumber.getName(), (Object)value);
        }

        public void setAuditTick(long value) {
            this.item.put(TableProcessorAudit.this.colTick.getName(), (Object)value);
        }
    }

    class AuditType
    implements ITableType {
        private final ITableType baseType;
        private final List<ITableColumn> columns;

        public AuditType(ITableType type) {
            this.baseType = type;
            this.columns = this.createColumns();
        }

        protected List<ITableColumn> createColumns() {
            ArrayList<ITableColumn> tmpColumns = new ArrayList<ITableColumn>();
            tmpColumns.add((ITableColumn)TableProcessorAudit.this.colCommand);
            tmpColumns.add((ITableColumn)TableProcessorAudit.this.colSequenceNumber);
            tmpColumns.add((ITableColumn)TableProcessorAudit.this.colTick);
            tmpColumns.addAll(this.baseType.getColumns());
            tmpColumns.add((ITableColumn)TableProcessorAudit.this.colSeal);
            return tmpColumns;
        }

        public ITableRecord createRecord() {
            ITableRecord tableRecord = this.baseType.createRecord();
            AuditRecord auditRecord = new AuditRecord(tableRecord);
            return auditRecord;
        }

        public List<ITableColumn> getColumns() {
            return this.columns;
        }

        public String getId() {
            return this.baseType.getId();
        }
    }
}

