/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.design.widget;

import de.intarsys.pdf.app.appearance.AppearanceCreatorTools;
import de.intarsys.pdf.app.appearance.IAppearanceCreator;
import de.intarsys.pdf.design.widget.AnnotationDefinition;
import de.intarsys.pdf.design.widget.AnnotationType;
import de.intarsys.pdf.design.widget.CommonFieldDefinitionStrategy;
import de.intarsys.pdf.design.widget.IFieldDefinition;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDObject;
import de.intarsys.tools.exception.ExceptionTools;
import java.util.ArrayList;

public class AcroFormFieldDefinitionStrategy
extends CommonFieldDefinitionStrategy {
    @Override
    public PDAcroFormField createField(PDDocument doc, IFieldDefinition fieldDefinition) {
        PDAcroFormField field = this.detectAcroFormField(doc, fieldDefinition);
        if (field == null) {
            return null;
        }
        ArrayList<AnnotationDefinition> annotationDefinitions = new ArrayList<AnnotationDefinition>();
        this.createAnnotationDefinitionsFromEndorsement(fieldDefinition, annotationDefinitions);
        try {
            this.createFieldAnnotations(annotationDefinitions, AnnotationType.markup, AnnotationType.markup, field);
        }
        catch (Exception e) {
            throw (IllegalArgumentException)ExceptionTools.unwrapTypedFromChain((Throwable)e, IllegalArgumentException.class);
        }
        IAppearanceCreator appearanceCreator = fieldDefinition.getAppearanceCreator();
        if (appearanceCreator != null) {
            AppearanceCreatorTools.setAppearanceCreator((PDObject)field, (IAppearanceCreator)appearanceCreator);
            AppearanceCreatorTools.createAppearance((PDAcroFormField)field);
        }
        return field;
    }
}

