/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.annotation.widget;

import de.intarsys.pdf.app.annotation.IAnnotationFactory;
import de.intarsys.pdf.app.annotation.common.CommonAnnotationFactory;
import de.intarsys.pdf.app.annotation.widget.WidgetCheckboxFactory;
import de.intarsys.pdf.app.annotation.widget.WidgetComboFactory;
import de.intarsys.pdf.app.annotation.widget.WidgetListFactory;
import de.intarsys.pdf.app.annotation.widget.WidgetPushbuttonFactory;
import de.intarsys.pdf.app.annotation.widget.WidgetRadioFactory;
import de.intarsys.pdf.app.annotation.widget.WidgetSignatureFactory;
import de.intarsys.pdf.app.annotation.widget.WidgetTextFactory;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.pd.AcroFormFieldFlags;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.pdf.pd.PDWidgetAnnotation;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.awt.geom.Rectangle2D;
import java.util.Map;

public class WidgetFactory
extends CommonAnnotationFactory {
    public static final String ATTR_FONT = "font";
    public static final String DEPRECATED_NAME = "name";
    public static final String STYLE = "style";
    private IAnnotationFactory textFactory = new WidgetTextFactory();
    private IAnnotationFactory radioFactory = new WidgetRadioFactory();
    private IAnnotationFactory pushbuttonFactory = new WidgetPushbuttonFactory();
    private IAnnotationFactory listFactory = new WidgetListFactory();
    private IAnnotationFactory comboFactory = new WidgetComboFactory();
    private IAnnotationFactory checkboxFactory = new WidgetCheckboxFactory();
    private IAnnotationFactory signatureFactory = new WidgetSignatureFactory();

    public static String getFieldName(Map attributes) {
        if (attributes == null) {
            return null;
        }
        String result = (String)attributes.get("fieldName");
        if (result == null) {
            result = (String)attributes.get(DEPRECATED_NAME);
        }
        return result;
    }

    public static void setFieldName(Map attributes, String fieldName) {
        if (attributes == null) {
            return;
        }
        attributes.put("fieldName", fieldName);
    }

    @Override
    protected PDAnnotation basicCreateAnnotation(PDPage page, CDSRectangle rect, Map attributes) throws ObjectCreationException {
        return null;
    }

    @Override
    public PDAnnotation createAnnotation(PDPage page, Rectangle2D rect, Map attributes) throws ObjectCreationException {
        COSName fieldType = (COSName)attributes.get(PDAcroFormField.DK_FT);
        Object tempFlags = attributes.get(PDAcroFormField.DK_Ff);
        AcroFormFieldFlags flags = tempFlags instanceof AcroFormFieldFlags ? (AcroFormFieldFlags)tempFlags : (tempFlags instanceof Number ? new AcroFormFieldFlags(((Number)tempFlags).intValue()) : new AcroFormFieldFlags(0));
        if (PDAcroFormField.CN_FT_Btn.equals((Object)fieldType)) {
            if (flags.isRadio()) {
                return this.radioFactory.createAnnotation(page, rect, attributes);
            }
            if (flags.isPushbutton()) {
                return this.pushbuttonFactory.createAnnotation(page, rect, attributes);
            }
            return this.checkboxFactory.createAnnotation(page, rect, attributes);
        }
        if (PDAcroFormField.CN_FT_Ch.equals((Object)fieldType)) {
            if (flags.isCombo()) {
                return this.comboFactory.createAnnotation(page, rect, attributes);
            }
            return this.listFactory.createAnnotation(page, rect, attributes);
        }
        if (PDAcroFormField.CN_FT_Sig.equals((Object)fieldType)) {
            return this.signatureFactory.createAnnotation(page, rect, attributes);
        }
        if (PDAcroFormField.CN_FT_Tx.equals((Object)fieldType)) {
            return this.textFactory.createAnnotation(page, rect, attributes);
        }
        return null;
    }

    public COSName getAnnotationType() {
        return PDWidgetAnnotation.CN_Subtype_Widget;
    }
}

