/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.annotation.markup;

import de.intarsys.pdf.app.annotation.markup.MarkupFactory;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDAppearance;
import de.intarsys.pdf.pd.PDForm;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.pdf.pd.PDStampAnnotation;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.awt.Shape;
import java.util.Map;

public class MarkupStampFactory
extends MarkupFactory {
    public static final String ATTR_STAMPNAME = "stampName";

    public static String getStampName(Map attributes) {
        return (String)attributes.get(ATTR_STAMPNAME);
    }

    @Override
    protected PDAnnotation basicCreateAnnotation(PDPage page, CDSRectangle rect, Map attributes) {
        PDStampAnnotation newAnnot = (PDStampAnnotation)PDStampAnnotation.META.createNew();
        return newAnnot;
    }

    @Override
    protected void createAnnotationPostProcess(PDPage page, PDAnnotation annotation, CDSRectangle rect, Map attributes) {
        PDForm form;
        super.createAnnotationPostProcess(page, annotation, rect, attributes);
        PDAppearance appearance = annotation.getAppearance();
        if (appearance != null && (form = appearance.getNormalAppearance(null)) != null) {
            float newWidth = rect.getWidth();
            float newHeight = rect.getHeight();
            if (newWidth <= 0.0f && newHeight <= 0.0f) {
                newWidth = form.getBoundingBox().getWidth();
                newHeight = form.getBoundingBox().getHeight();
                rect.resizeTo(newWidth, newHeight);
            }
        }
    }

    @Override
    protected void createAnnotationState(PDPage page, PDAnnotation annotation, CDSRectangle rect, Map attributes) throws ObjectCreationException {
        String name = MarkupStampFactory.getStampName(attributes);
        if (name != null) {
            annotation.setFieldName(PDStampAnnotation.DK_Name, name);
            annotation.setContents(name);
        } else {
            annotation.setContents("unknown");
        }
        super.createAnnotationState(page, annotation, rect, attributes);
    }

    @Override
    protected void createAnnotationStateFromShape(PDAnnotation annotation, Shape shape) {
    }

    public COSName getAnnotationType() {
        return PDStampAnnotation.CN_Subtype_Stamp;
    }
}

