/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.enumeration.common;

import de.intarsys.tools.enumeration.EnumItem;
import de.intarsys.tools.enumeration.common.EnumAlignment;
import de.intarsys.tools.enumeration.common.EnumResize;
import de.intarsys.tools.enumeration.common.IAlignment;
import de.intarsys.tools.enumeration.common.IResize;
import de.intarsys.tools.string.StringTools;

public class RectAlignment {
    public static final RectAlignment START_START = new RectAlignment();
    private IAlignment horizontalAlignment = EnumAlignment.START;
    private IAlignment verticalAlignment = EnumAlignment.START;
    private IResize horizontalResize = EnumResize.NEVER;
    private IResize verticalResize = EnumResize.NEVER;
    private boolean proportional = true;

    public static RectAlignment create() {
        return new RectAlignment();
    }

    public static RectAlignment create(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof RectAlignment) {
            return (RectAlignment)value;
        }
        if (value instanceof String) {
            return RectAlignment.parse((String)value);
        }
        throw new IllegalArgumentException("alignment definition '" + value + "' not supported");
    }

    public static RectAlignment parse(String definition) {
        if (StringTools.isEmpty((String)definition)) {
            return null;
        }
        RectAlignment result = new RectAlignment();
        String[] splitDefinition = definition.split("[;]");
        if (splitDefinition.length > 4) {
            throw new IllegalArgumentException("alignment definition requires hAlign [ ';' vAlign [ ';' hResize [ ';' vResize ]]]");
        }
        int next = 0;
        String hAlignString = splitDefinition[next++].trim().toLowerCase();
        EnumAlignment hAlign = (EnumAlignment)EnumAlignment.META.getItemStrict(hAlignString, (EnumItem)EnumAlignment.START);
        String vAlignString = splitDefinition.length > next ? splitDefinition[next++].trim().toLowerCase() : hAlignString;
        EnumAlignment vAlign = null;
        String hResizeString = null;
        EnumResize hResize = null;
        try {
            vAlign = (EnumAlignment)EnumAlignment.META.getItemStrict(vAlignString, (EnumItem)hAlign);
            hResizeString = splitDefinition.length > next ? splitDefinition[next++].trim().toLowerCase() : "never";
        }
        catch (Exception e) {
            vAlign = hAlign;
            hResizeString = vAlignString;
        }
        hResize = (EnumResize)EnumResize.META.getItemStrict(hResizeString, (EnumItem)EnumResize.NEVER);
        String vResizeString = splitDefinition.length > next ? splitDefinition[next++].trim().toLowerCase() : hResizeString;
        EnumResize vResize = (EnumResize)EnumResize.META.getItemStrict(vResizeString, (EnumItem)((EnumResize)result.getHorizontalResize()));
        result.setHorizontalAlignment(hAlign);
        result.setVerticalAlignment(vAlign);
        result.setHorizontalResize(hResize);
        result.setVerticalResize(vResize);
        return result;
    }

    public IAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public IResize getHorizontalResize() {
        return this.horizontalResize;
    }

    public IAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public IResize getVerticalResize() {
        return this.verticalResize;
    }

    public boolean isProportional() {
        return this.proportional;
    }

    public void setHorizontalAlignment(IAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public void setHorizontalResize(IResize horizontalFix) {
        this.horizontalResize = horizontalFix;
    }

    public void setProportional(boolean proportional) {
        this.proportional = proportional;
    }

    public void setVerticalAlignment(IAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public void setVerticalResize(IResize verticalFix) {
        this.verticalResize = verticalFix;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.horizontalAlignment);
        if (this.verticalAlignment != this.horizontalAlignment) {
            sb.append(";");
            sb.append(this.verticalAlignment);
        }
        sb.append(";");
        sb.append(this.horizontalResize);
        if (this.verticalResize != this.horizontalResize) {
            sb.append(";");
            sb.append(this.verticalResize);
        }
        return sb.toString();
    }
}

