/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.enumeration.common;

import de.intarsys.tools.enumeration.EnumItem;
import de.intarsys.tools.enumeration.common.EnumAlignment;
import de.intarsys.tools.enumeration.common.IAlignment;
import de.intarsys.tools.string.StringTools;

public class PointAlignment {
    public static final PointAlignment START_START = new PointAlignment();
    private IAlignment horizontal = EnumAlignment.START;
    private IAlignment vertical = EnumAlignment.START;

    public static PointAlignment create(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof PointAlignment) {
            return (PointAlignment)value;
        }
        if (value instanceof String) {
            return PointAlignment.parse((String)value);
        }
        throw new IllegalArgumentException("alignment definition '" + value + "' not supported");
    }

    public static PointAlignment parse(String definition) {
        if (StringTools.isEmpty((String)definition)) {
            return null;
        }
        PointAlignment result = new PointAlignment();
        String[] splitDefinition = definition.split("[;]");
        if (splitDefinition.length > 2) {
            throw new IllegalArgumentException("alignment definition requires hAlign [ ';' vAlign ]");
        }
        String hAlignString = splitDefinition[0].trim().toLowerCase();
        String vAlignString = splitDefinition.length > 1 ? splitDefinition[1].trim().toLowerCase() : hAlignString;
        result.setHorizontal((IAlignment)EnumAlignment.META.getItemStrict(hAlignString, (EnumItem)EnumAlignment.START));
        result.setVertical((IAlignment)EnumAlignment.META.getItemStrict(vAlignString, (EnumItem)((EnumAlignment)result.getHorizontal())));
        return result;
    }

    public IAlignment getHorizontal() {
        return this.horizontal;
    }

    public IAlignment getVertical() {
        return this.vertical;
    }

    protected void setHorizontal(IAlignment hAnchor) {
        this.horizontal = hAnchor;
    }

    protected void setVertical(IAlignment vAnchor) {
        this.vertical = vAnchor;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.horizontal);
        sb.append(";");
        sb.append(this.vertical);
        return sb.toString();
    }
}

