/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.health;

import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.device.health.ConcurrentHealthMonitor;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;

public class ConnectHealthMonitor
extends ConcurrentHealthMonitor<CommonDevice> {
    private String host;
    private int port;
    private int timeout = 1000;

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getTimeout() {
        return this.timeout;
    }

    @Override
    protected void monitor() {
        Socket socket = new Socket();
        try {
            InetSocketAddress address = new InetSocketAddress(this.getHost(), this.getPort());
            socket.connect(address, this.getTimeout());
            this.success();
        }
        catch (IOException e) {
            this.fail(e);
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public void setArgs(IArgs args) {
        super.setArgs(args);
        this.setHost(ArgTools.getString((IArgs)args, (String)"host", null));
        this.setPort(ArgTools.getInt((IArgs)args, (String)"port", (int)0));
        this.setTimeout(ArgTools.getInt((IArgs)args, (String)"timeout", (int)1000));
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

