/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.common;

import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.expression.MapAccessor;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.DataBindingPropertyAccessor;
import org.springframework.expression.spel.support.SimpleEvaluationContext;

public abstract class AbstractQuery {
    private static final Logger Log = LoggerFactory.getLogger(AbstractQuery.class);
    private static SimpleEvaluationContext context = SimpleEvaluationContext.forPropertyAccessors((PropertyAccessor[])new PropertyAccessor[]{new MapAccessor(), DataBindingPropertyAccessor.forReadOnlyAccess()}).withInstanceMethods().build();
    private final String expr;

    protected AbstractQuery(String expr) {
        if (expr == null) {
            throw new IllegalArgumentException("expression cannot be null");
        }
        this.expr = expr;
    }

    protected boolean queryObject(String bindingName, Object wrapper) {
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put(bindingName, wrapper);
        try {
            SpelExpressionParser parser = new SpelExpressionParser();
            Expression exp = parser.parseExpression(this.expr);
            Boolean result = (Boolean)exp.getValue((EvaluationContext)context, root, Boolean.class);
            boolean bool = Boolean.TRUE.equals(result);
            if (bool) {
                Log.trace("[" + wrapper + "] accepted for " + this);
            } else {
                Log.trace("[" + wrapper + "] rejected for " + this);
            }
            return bool;
        }
        catch (Exception e) {
            Log.trace("[" + wrapper + "] evaluation failed for " + this, (Throwable)e);
            return false;
        }
    }

    public String toString() {
        return this.expr;
    }
}

