/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.signature;

import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.signature.ISignatureContainerEntryProcessor;
import de.intarsys.security.app.validation.ISignatureContainerEntryExtender;
import de.intarsys.security.app.validation.IValidationContext;
import de.intarsys.security.app.validation.IValidationDataCollector;
import de.intarsys.security.app.validation.IValidationParameters;
import de.intarsys.security.app.validation.ValidationParameters;
import de.intarsys.security.app.validation.common.EntryStateValidationDataCollector;
import de.intarsys.security.app.validation.common.EntryValidationDataCollector;
import de.intarsys.security.app.validation.common.StateCachingStrategy;
import de.intarsys.security.method.common.signature.ISignatureContainerBuilder;
import de.intarsys.security.signature.ISignatureContainerEntry;
import de.intarsys.security.signature.ValidationDataOptions;
import de.intarsys.security.signature.common.ISignatureData;
import de.intarsys.security.standard.validation.commonpki.OCSPDepth;
import de.intarsys.security.validation.IExtendedValidationData;
import de.intarsys.security.validation.IExtendedValidationDataSupport;
import de.intarsys.security.validation.IVSSignatureContainerEntry;
import de.intarsys.security.validation.IValidationState;
import de.intarsys.security.validation.ValidationEnvironment;
import de.intarsys.tools.adapter.AdapterTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.function.Supplier;

public abstract class CommonValidationDataExtender<T extends ISignatureContainerEntry>
implements ISignatureContainerEntryExtender,
ISignatureContainerEntryProcessor<T> {
    private ValidationDataOptions validationDataOptions = ValidationDataOptions.NONE;
    private boolean failOnError = false;
    private long maxSize = -1L;
    private Supplier<IValidationDataCollector> validationDataCollector;

    public void extend(IVSSignatureContainerEntry entryState) throws GeneralSecurityException, IOException {
        IValidationDataCollector collector = null;
        if (this.getValidationDataCollector() != null) {
            collector = this.getValidationDataCollector().get();
        }
        if (collector == null) {
            EntryStateValidationDataCollector entryCollector = new EntryStateValidationDataCollector((IValidationState)entryState);
            entryCollector.setValidationDataOptions(this.getValidationDataOptions());
            collector = entryCollector;
        }
        IExtendedValidationData validationData = collector.collect();
        this.extend(entryState.getEntry(), validationData);
    }

    protected abstract void extend(T var1, IExtendedValidationData var2) throws IOException;

    public long getMaxSize() {
        return this.maxSize;
    }

    public Supplier<IValidationDataCollector> getValidationDataCollector() {
        return this.validationDataCollector;
    }

    public ValidationDataOptions getValidationDataOptions() {
        return this.validationDataOptions;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    @Override
    public void process(ISignatureContainerBuilder builder, T entry, ISignatureData signatureData) throws SecurityApplicationException, IOException {
        IExtendedValidationDataSupport validationDataSupport;
        IExtendedValidationData validationData = (IExtendedValidationData)AdapterTools.getAdapter((Object)signatureData, IExtendedValidationData.class, null);
        if (validationData == null && (validationDataSupport = (IExtendedValidationDataSupport)AdapterTools.getAdapter((Object)signatureData, IExtendedValidationDataSupport.class, null)) != null) {
            validationData = validationDataSupport.getExtendedValidationData();
        }
        if (validationData == null) {
            IValidationDataCollector collector = null;
            if (this.getValidationDataCollector() != null) {
                collector = this.getValidationDataCollector().get();
            }
            if (collector == null) {
                EntryValidationDataCollector entryCollector = new EntryValidationDataCollector(entry);
                entryCollector.setValidationDataOptions(this.getValidationDataOptions());
                collector = entryCollector;
            }
            validationData = collector.collect();
        }
        this.extend(entry, validationData);
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }

    public void setValidationDataCollector(Supplier<IValidationDataCollector> validationDataCollector) {
        this.validationDataCollector = validationDataCollector;
    }

    public void setValidationDataOptions(ValidationDataOptions validationDataOptions) {
        this.validationDataOptions = validationDataOptions;
    }

    protected IValidationState validate(ISignatureContainerEntry entry) {
        Args contextArgs = Args.create();
        contextArgs.put("checkCRL", (Object)this.getValidationDataOptions().isAddRevocationInfoTypeCrl());
        contextArgs.put("checkOCSP", (Object)this.getValidationDataOptions().isAddRevocationInfoTypeOcsp());
        contextArgs.put("ocspDepth", (Object)OCSPDepth.FULL);
        contextArgs.put("stateCachingStrategy", (Object)StateCachingStrategy.noCache());
        IValidationContext context = ValidationEnvironment.get().getValidationContextFactory().createValidationContext((IArgs)contextArgs);
        ValidationParameters parameters = new ValidationParameters();
        return context.getSignatureContainerEntryValidator().validate(entry, null, (IValidationParameters)parameters);
    }
}

