/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.st;

import de.intarsys.pdf.cos.COSObjectKey;
import de.intarsys.pdf.st.IXRefEntryVisitor;
import de.intarsys.pdf.st.STXRefEntry;
import de.intarsys.pdf.st.STXRefEntryCompressed;
import de.intarsys.pdf.st.STXRefEntryFree;
import de.intarsys.pdf.st.STXRefEntryOccupied;
import de.intarsys.pdf.st.STXRefSection;
import de.intarsys.pdf.st.STXRefSubsection;
import de.intarsys.pdf.st.XRefEntryVisitorException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class STTools {
    public static Map<COSObjectKey, STXRefEntry> getOccupiedEntries(STXRefSection section) throws IOException {
        LinkedHashMap<COSObjectKey, STXRefEntry> entries = new LinkedHashMap<COSObjectKey, STXRefEntry>();
        STXRefSection previous = section.getPrevious();
        if (previous != null) {
            entries.putAll(STTools.getOccupiedEntries(previous));
        }
        entries.putAll(STTools.getOccupiedEntriesExclusive(section));
        return entries;
    }

    public static Map<COSObjectKey, STXRefEntry> getOccupiedEntriesExclusive(STXRefSection section) throws IOException {
        EntryCollector collector = new EntryCollector();
        STTools.visitEntries(section, collector);
        Map<COSObjectKey, STXRefEntry> entries = collector.getEntries();
        return entries;
    }

    public static void visitEntries(STXRefSection section, IXRefEntryVisitor visitor) throws IOException {
        Iterator i = section.subsectionIterator();
        while (i.hasNext()) {
            STXRefSubsection subsection = (STXRefSubsection)i.next();
            Iterator ie = subsection.getEntries().iterator();
            while (ie.hasNext()) {
                try {
                    ((STXRefEntry)ie.next()).accept(visitor);
                }
                catch (XRefEntryVisitorException e) {
                    throw (IOException)e.getCause();
                }
            }
        }
    }

    private STTools() {
    }

    public static class EntryCollector
    implements IXRefEntryVisitor {
        private Map<COSObjectKey, STXRefEntry> entries = new HashMap<COSObjectKey, STXRefEntry>();

        public Map<COSObjectKey, STXRefEntry> getEntries() {
            return this.entries;
        }

        @Override
        public void visitFromCompressed(STXRefEntryCompressed entry) throws XRefEntryVisitorException {
            if (entry.getObjectNumber() == 0) {
                return;
            }
            this.entries.put(new COSObjectKey(entry.getObjectNumber(), entry.getGenerationNumber()), entry);
        }

        @Override
        public void visitFromFree(STXRefEntryFree entry) throws XRefEntryVisitorException {
        }

        @Override
        public void visitFromOccupied(STXRefEntryOccupied entry) throws XRefEntryVisitorException {
            if (entry.getObjectNumber() == 0) {
                return;
            }
            this.entries.put(new COSObjectKey(entry.getObjectNumber(), entry.getGenerationNumber()), entry);
        }
    }
}

