/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.action;

import de.intarsys.pdf.app.action.ActionProcessor;
import de.intarsys.pdf.app.action.TriggerEvent;
import de.intarsys.pdf.cds.CDSNameTreeNode;
import de.intarsys.pdf.cds.CDSTreeEntry;
import de.intarsys.pdf.cos.COSCatalog;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSDocument;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.pd.IAdditionalActionSupport;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDAction;
import de.intarsys.pdf.pd.PDActionGoTo;
import de.intarsys.pdf.pd.PDAdditionalActions;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.pdf.pd.PDWidgetAnnotation;
import de.intarsys.tools.attribute.Attribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class ActionTools {
    public static final COSName DK_JavaScript = COSName.constant("JavaScript");
    private static final Logger Log = LoggerFactory.getLogger(ActionTools.class);
    private static final Attribute ATTR_DISABLEDACTIONS = new Attribute("disabledActions");

    public static TriggerEvent annotationTriggerBlurred(PDAnnotation annotation) {
        if (Log.isEnabledForLevel(Level.TRACE)) {
            Log.trace("blurred [" + annotation.toString() + "]");
        }
        PDWidgetAnnotation widget = (PDWidgetAnnotation)annotation;
        PDAcroFormField field = widget.getAcroFormField();
        TriggerEvent trigger = new TriggerEvent(annotation.getDoc(), PDAdditionalActions.CN_trigger_Bl);
        trigger.setTarget(field.getLogicalRoot());
        trigger.setValue(field.getValueString());
        trigger.setTargetName(field.getQualifiedName());
        ActionTools.process(trigger, field);
        return trigger;
    }

    public static TriggerEvent annotationTriggerFocus(PDAnnotation annotation) {
        if (Log.isEnabledForLevel(Level.TRACE)) {
            Log.trace("focus [" + annotation.toString() + "]");
        }
        PDWidgetAnnotation widget = (PDWidgetAnnotation)annotation;
        PDAcroFormField field = widget.getAcroFormField();
        TriggerEvent trigger = new TriggerEvent(annotation.getDoc(), PDAdditionalActions.CN_trigger_Fo);
        trigger.setTarget(field.getLogicalRoot());
        trigger.setValue(field.getValueString());
        trigger.setTargetName(field.getQualifiedName());
        ActionTools.process(trigger, field);
        return trigger;
    }

    public static TriggerEvent annotationTriggerKeystroke(PDAnnotation annotation, String change, boolean willCommit, int commitKey, boolean modifier, int selStart, int selEnd, boolean shift, String value) {
        if (Log.isEnabledForLevel(Level.TRACE)) {
            Log.trace("keystroke [" + annotation.toString() + "]");
        }
        PDWidgetAnnotation widget = (PDWidgetAnnotation)annotation;
        PDAcroFormField field = widget.getAcroFormField().getLogicalRoot();
        TriggerEvent trigger = new TriggerEvent(field.getDoc(), PDAdditionalActions.CN_trigger_K);
        trigger.setChange(change);
        trigger.setWillCommit(willCommit);
        trigger.setCommitKey(commitKey);
        trigger.setModifier(modifier);
        trigger.setSelStart(selStart);
        trigger.setSelEnd(selEnd);
        trigger.setShift(shift);
        trigger.setTarget(field.getLogicalRoot());
        trigger.setTargetName(field.getQualifiedName());
        trigger.setValue(value);
        ActionTools.process(trigger, field);
        return trigger;
    }

    public static TriggerEvent annotationTriggerMouseDown(PDAnnotation annotation) {
        PDAction action;
        if (Log.isEnabledForLevel(Level.TRACE)) {
            Log.trace("mouse down [" + annotation.toString() + "]");
        }
        if ((action = ActionTools.getAction(annotation, PDAdditionalActions.CN_trigger_D)) == null) {
            return null;
        }
        TriggerEvent trigger = new TriggerEvent(annotation.getDoc(), PDAdditionalActions.CN_trigger_D);
        trigger.setTarget(ActionTools.getTriggerEventTarget(annotation));
        ActionProcessor.get().process(trigger, action.cosGetActionType(), action.cosGetObject());
        return trigger;
    }

    public static TriggerEvent annotationTriggerMouseEnter(PDAnnotation annotation) {
        PDAction action;
        if (Log.isEnabledForLevel(Level.TRACE)) {
            Log.trace("mouse enter [" + annotation.toString() + "]");
        }
        if ((action = ActionTools.getAction(annotation, PDAdditionalActions.CN_trigger_E)) == null) {
            return null;
        }
        TriggerEvent trigger = new TriggerEvent(annotation.getDoc(), PDAdditionalActions.CN_trigger_E);
        trigger.setTarget(ActionTools.getTriggerEventTarget(annotation));
        ActionProcessor.get().process(trigger, action.cosGetActionType(), action.cosGetObject());
        return trigger;
    }

    public static TriggerEvent annotationTriggerMouseExit(PDAnnotation annotation) {
        PDAction action;
        if (Log.isEnabledForLevel(Level.TRACE)) {
            Log.trace("mouse exit [" + annotation.toString() + "]");
        }
        if ((action = ActionTools.getAction(annotation, PDAdditionalActions.CN_trigger_X)) == null) {
            return null;
        }
        TriggerEvent trigger = new TriggerEvent(annotation.getDoc(), PDAdditionalActions.CN_trigger_X);
        trigger.setTarget(ActionTools.getTriggerEventTarget(annotation));
        ActionProcessor.get().process(trigger, action.cosGetActionType(), action.cosGetObject());
        return trigger;
    }

    public static TriggerEvent annotationTriggerMouseUp(PDAnnotation annotation) {
        TriggerEvent trigger;
        COSDictionary cosAction;
        if (Log.isEnabledForLevel(Level.TRACE)) {
            Log.trace("mouse up [" + annotation.toString() + "]");
        }
        if ((cosAction = annotation.cosGetField(PDAnnotation.DK_A).asDictionary()) != null) {
            trigger = new TriggerEvent(annotation.getDoc(), null);
            trigger.setTarget(ActionTools.getTriggerEventTarget(annotation));
            COSName cosType = cosAction.get(PDAction.DK_S).asName();
            ActionProcessor.get().process(trigger, cosType, cosAction);
        } else {
            PDAction action = ActionTools.getAction(annotation, PDAdditionalActions.CN_trigger_U);
            if (action == null) {
                return null;
            }
            trigger = new TriggerEvent(annotation.getDoc(), PDAdditionalActions.CN_trigger_U);
            trigger.setTarget(ActionTools.getTriggerEventTarget(annotation));
            ActionProcessor.get().process(trigger, action.cosGetActionType(), action.cosGetObject());
        }
        return trigger;
    }

    public static TriggerEvent annotationTriggerPageClose(PDAnnotation annotation) {
        PDAction action;
        if (Log.isEnabledForLevel(Level.TRACE)) {
            Log.trace("page close [" + annotation.toString() + "]");
        }
        if ((action = ActionTools.getAction(annotation, PDAdditionalActions.CN_trigger_PC)) == null) {
            return null;
        }
        TriggerEvent trigger = new TriggerEvent(annotation.getDoc(), PDAdditionalActions.CN_trigger_PC);
        trigger.setTarget(ActionTools.getTriggerEventTarget(annotation));
        ActionProcessor.get().process(trigger, action.cosGetActionType(), action.cosGetObject());
        return trigger;
    }

    public static TriggerEvent annotationTriggerPageInvisible(PDAnnotation annotation) {
        PDAction action;
        if (Log.isEnabledForLevel(Level.TRACE)) {
            Log.trace("page invisible [" + annotation.toString() + "]");
        }
        if ((action = ActionTools.getAction(annotation, PDAdditionalActions.CN_trigger_PI)) == null) {
            return null;
        }
        TriggerEvent trigger = new TriggerEvent(annotation.getDoc(), PDAdditionalActions.CN_trigger_PI);
        trigger.setTarget(ActionTools.getTriggerEventTarget(annotation));
        ActionProcessor.get().process(trigger, action.cosGetActionType(), action.cosGetObject());
        return trigger;
    }

    public static TriggerEvent annotationTriggerPageOpen(PDAnnotation annotation) {
        PDAction action;
        if (Log.isEnabledForLevel(Level.TRACE)) {
            Log.trace("page open [" + annotation.toString() + "]");
        }
        if ((action = ActionTools.getAction(annotation, PDAdditionalActions.CN_trigger_PO)) == null) {
            return null;
        }
        TriggerEvent trigger = new TriggerEvent(annotation.getDoc(), PDAdditionalActions.CN_trigger_PO);
        trigger.setTarget(ActionTools.getTriggerEventTarget(annotation));
        ActionProcessor.get().process(trigger, action.cosGetActionType(), action.cosGetObject());
        return trigger;
    }

    public static TriggerEvent annotationTriggerPageVisible(PDAnnotation annotation) {
        PDAction action;
        if (Log.isEnabledForLevel(Level.TRACE)) {
            Log.trace("page visible [" + annotation.toString() + "]");
        }
        if ((action = ActionTools.getAction(annotation, PDAdditionalActions.CN_trigger_PV)) == null) {
            return null;
        }
        TriggerEvent trigger = new TriggerEvent(annotation.getDoc(), PDAdditionalActions.CN_trigger_PV);
        trigger.setTarget(ActionTools.getTriggerEventTarget(annotation));
        ActionProcessor.get().process(trigger, action.cosGetActionType(), action.cosGetObject());
        return trigger;
    }

    public static ActionDisablement disableActions(COSDocument doc, COSName actionType) {
        ArrayList<ActionDisablement> disablements = (ArrayList<ActionDisablement>)doc.getAttribute(ATTR_DISABLEDACTIONS);
        if (disablements == null) {
            disablements = new ArrayList<ActionDisablement>();
            doc.setAttribute(ATTR_DISABLEDACTIONS, disablements);
        }
        ActionDisablement disablement = new ActionDisablement();
        disablement.actionType = actionType;
        disablements.add(disablement);
        return disablement;
    }

    public static void documentProcessModules(PDDocument doc) {
        COSCatalog catalog = doc.getCatalog();
        if (catalog == null) {
            return;
        }
        COSDictionary names = catalog.cosGetNames();
        if (names == null) {
            return;
        }
        CDSNameTreeNode tree = CDSNameTreeNode.createFromCos(names.get(DK_JavaScript).asDictionary());
        if (tree == null) {
            return;
        }
        Iterator it = tree.iterator();
        while (it.hasNext()) {
            String actionName;
            CDSTreeEntry entry = (CDSTreeEntry)it.next();
            COSObject cosActionName = entry.getKey();
            if (cosActionName != null && !cosActionName.isNull() && (actionName = cosActionName.stringValue()).toUpperCase().startsWith("!ADBE::")) continue;
            COSObject actionDefinition = entry.getValue();
            TriggerEvent event = new TriggerEvent(doc, null);
            ActionProcessor.get().process(event, DK_JavaScript, actionDefinition);
        }
    }

    public static TriggerEvent documentTriggerClose(PDDocument doc) {
        if (Log.isEnabledForLevel(Level.TRACE)) {
            Log.trace("document close [" + doc.getName() + "]");
        }
        TriggerEvent trigger = new TriggerEvent(doc, PDAdditionalActions.CN_trigger_DC);
        trigger.setTarget(doc);
        ActionTools.process(trigger, doc);
        trigger = new TriggerEvent(doc, PDAdditionalActions.CN_trigger_WC);
        trigger.setTarget(doc);
        ActionTools.process(trigger, doc);
        return trigger;
    }

    public static TriggerEvent documentTriggerDidPrint(PDDocument doc) {
        if (Log.isEnabledForLevel(Level.TRACE)) {
            Log.trace("did print [" + doc.getName() + "]");
        }
        TriggerEvent trigger = new TriggerEvent(doc, PDAdditionalActions.CN_trigger_DP);
        trigger.setTarget(doc);
        ActionTools.process(trigger, doc);
        return trigger;
    }

    public static TriggerEvent documentTriggerDidSave(PDDocument doc) {
        if (Log.isEnabledForLevel(Level.TRACE)) {
            Log.trace("did save [" + doc.getName() + "]");
        }
        TriggerEvent trigger = new TriggerEvent(doc, PDAdditionalActions.CN_trigger_DS);
        trigger.setTarget(doc);
        ActionTools.process(trigger, doc);
        return trigger;
    }

    public static TriggerEvent documentTriggerOpen(PDDocument doc) {
        if (Log.isEnabledForLevel(Level.TRACE)) {
            Log.trace("document open [" + doc.getName() + "]");
        }
        TriggerEvent trigger = new TriggerEvent(doc, null);
        trigger.setTarget(doc);
        COSObject action = doc.getCatalog().cosGetOpenAction();
        if (action.isNull()) {
            return null;
        }
        COSName cosType = null;
        cosType = action instanceof COSDictionary ? ((COSDictionary)action).get(PDAction.DK_S).asName() : PDActionGoTo.CN_ActionType_GoTo;
        ActionProcessor.get().process(trigger, cosType, action);
        return trigger;
    }

    public static TriggerEvent documentTriggerWillPrint(PDDocument doc) {
        if (Log.isEnabledForLevel(Level.TRACE)) {
            Log.trace("will print [" + doc.getName() + "]");
        }
        TriggerEvent trigger = new TriggerEvent(doc, PDAdditionalActions.CN_trigger_WP);
        trigger.setTarget(doc);
        ActionTools.process(trigger, doc);
        return trigger;
    }

    public static TriggerEvent documentTriggerWillSave(PDDocument doc) {
        if (Log.isEnabledForLevel(Level.TRACE)) {
            Log.trace("will save [" + doc.getName() + "]");
        }
        TriggerEvent trigger = new TriggerEvent(doc, PDAdditionalActions.CN_trigger_WS);
        trigger.setTarget(doc);
        ActionTools.process(trigger, doc);
        return trigger;
    }

    public static void enableActions(COSDocument doc, ActionDisablement disablement) {
        ArrayList disablements = (ArrayList)doc.getAttribute(ATTR_DISABLEDACTIONS);
        if (disablements == null) {
            disablements = new ArrayList();
            doc.setAttribute(ATTR_DISABLEDACTIONS, disablements);
        }
        disablements.remove(disablement);
    }

    public static TriggerEvent fieldTriggerCalculate(PDAcroFormField field, String value, PDAcroFormField source) {
        if (Log.isEnabledForLevel(Level.TRACE)) {
            Log.trace("calculate [" + field.toString() + "]");
        }
        field = field.getLogicalRoot();
        TriggerEvent trigger = new TriggerEvent(source, field.getDoc(), PDAdditionalActions.CN_trigger_C);
        trigger.setTarget(field);
        trigger.setValue(value);
        trigger.setTargetName(field.getQualifiedName());
        ActionTools.process(trigger, field);
        return trigger;
    }

    public static TriggerEvent fieldTriggerFormat(PDAcroFormField field, boolean willCommit, int commitKey, String value) {
        if (Log.isEnabledForLevel(Level.TRACE)) {
            Log.trace("format [" + field.toString() + "]");
        }
        field = field.getLogicalRoot();
        TriggerEvent trigger = new TriggerEvent(field.getDoc(), PDAdditionalActions.CN_trigger_F);
        trigger.setWillCommit(willCommit);
        trigger.setCommitKey(commitKey);
        trigger.setTarget(field.getLogicalRoot());
        trigger.setTargetName(field.getQualifiedName());
        trigger.setValue(value);
        ActionTools.process(trigger, field);
        return trigger;
    }

    public static TriggerEvent fieldTriggerValidate(PDAcroFormField field, String value) {
        if (Log.isEnabledForLevel(Level.TRACE)) {
            Log.trace("validate [" + field.toString() + "]");
        }
        field = field.getLogicalRoot();
        TriggerEvent trigger = new TriggerEvent(field.getDoc(), PDAdditionalActions.CN_trigger_V);
        trigger.setTarget(field.getLogicalRoot());
        trigger.setTargetName(field.getQualifiedName());
        trigger.setValue(value);
        ActionTools.process(trigger, field);
        return trigger;
    }

    protected static PDAction getAction(IAdditionalActionSupport actionSupport, COSName reason) {
        if (actionSupport == null) {
            return null;
        }
        PDAdditionalActions actions = actionSupport.getAdditionalActions();
        if (actions == null) {
            return null;
        }
        return actions.getAction(reason);
    }

    protected static Object getTriggerEventTarget(PDAnnotation annotation) {
        if (annotation.isWidgetAnnotation()) {
            return ((PDWidgetAnnotation)annotation).getAcroFormField().getLogicalRoot();
        }
        return annotation;
    }

    public static boolean isEnabled(COSDocument doc, COSName actionType) {
        List disablements = (List)doc.getAttribute(ATTR_DISABLEDACTIONS);
        if (disablements == null) {
            return true;
        }
        for (ActionDisablement disablement : disablements) {
            if (disablement.actionType != null && !disablement.actionType.equals(actionType)) continue;
            return false;
        }
        return true;
    }

    public static TriggerEvent pageTriggerClose(PDPage page) {
        if (Log.isEnabledForLevel(Level.TRACE)) {
            Log.trace("close [" + page.toString() + "]");
        }
        TriggerEvent trigger = new TriggerEvent(page.getDoc(), PDAdditionalActions.CN_trigger_C);
        trigger.setTarget(page);
        ActionTools.process(trigger, page);
        return trigger;
    }

    public static TriggerEvent pageTriggerOpen(PDPage page) {
        if (Log.isEnabledForLevel(Level.TRACE)) {
            Log.trace("open [" + page.toString() + "]");
        }
        TriggerEvent trigger = new TriggerEvent(page.getDoc(), PDAdditionalActions.CN_trigger_O);
        trigger.setTarget(page);
        ActionTools.process(trigger, page);
        return trigger;
    }

    protected static void process(TriggerEvent event, IAdditionalActionSupport actionSupport) {
        if (actionSupport == null && event.getTarget() instanceof IAdditionalActionSupport) {
            actionSupport = (IAdditionalActionSupport)event.getTarget();
        }
        if (actionSupport == null) {
            return;
        }
        PDAdditionalActions actions = actionSupport.getAdditionalActions();
        if (actions == null) {
            return;
        }
        PDAction action = actions.getAction(event.getReason());
        if (action == null) {
            return;
        }
        ActionProcessor.get().process(event, action.cosGetActionType(), action.cosGetObject());
    }

    private ActionTools() {
    }

    public static class ActionDisablement {
        protected COSName actionType;
    }
}

