/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.jca.device;

import de.intarsys.security.app.IAuthenticatedApplication;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.jca.device.DevicePrivateKey;
import de.intarsys.security.signature.common.ISignatureData;
import de.intarsys.security.signature.common.IToBeSignedData;
import de.intarsys.security.signature.common.ToBeSignedData;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.driver.ConversationDriver;
import de.intarsys.tools.crypto.CryptoTools;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.digest.IDigester;
import de.intarsys.tools.digest.NullDigester;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.util.concurrent.ExecutionException;

public abstract class DeviceSignatureSpi
extends SignatureSpi {
    public static final String ARG_RSASIGNATUREENCODING = "rsaSignatureEncoding";
    public static final String RSAENCODING_RSA = "RSA";
    public static final String RSAENCODING_RSASSAPSS = "RSASSA-PSS";
    private final IDigester initialDigester;
    private IDigester digester;
    private DevicePrivateKey privateKey;

    public DeviceSignatureSpi(IDigester digester) throws GeneralSecurityException {
        this.initialDigester = digester;
        if (this.initialDigester == null) {
            this.setDigester(this.createDefaultDigester());
        } else {
            this.setDigester(this.initialDigester);
        }
    }

    protected abstract void checkPrivateKey(PrivateKey var1) throws InvalidKeyException;

    protected void checkSigner(ISigner signer) throws SignatureException {
        if (signer == null) {
            throw new SignatureException("ISigner cannot be created");
        }
        if (!signer.isBasic()) {
            throw new SignatureException("ISigner must be on basic level");
        }
    }

    protected void cleanup() {
        this.getDigester().reset();
        this.setPrivateKey(null);
    }

    protected IDigester createDefaultDigester() throws NoSuchAlgorithmException {
        return new NullDigester();
    }

    protected ISigner createSigner(DevicePrivateKey devicePrivateKey) throws SignatureException {
        IArgs allArgs = this.createSignerArgs();
        ArgTools.putPath((IArgs)allArgs, (String)"signerIdentifier", (Object)devicePrivateKey.getPrincipal().getX509PublicKeyCertificate());
        if (!CryptoTools.isEmpty((Secret)devicePrivateKey.getPassword())) {
            ArgTools.putPath((IArgs)allArgs, (String)"signerPassword", (Object)devicePrivateKey.getPassword());
        }
        try {
            ISigner signer = (ISigner)devicePrivateKey.getDevice().createApplication(ISigner.class.getName(), allArgs);
            if (!(this.getDigester() instanceof NullDigester)) {
                if (!signer.getSupportedHashAlgorithmNames().contains(this.getDigester().getAlgorithmName())) {
                    throw new SignatureException("ISigner does not support " + this.getDigester().getAlgorithmName());
                }
                signer.setHashAlgorithmName(this.getDigester().getAlgorithmName());
            }
            return signer;
        }
        catch (SecurityApplicationException e) {
            throw new SignatureException("Cannot create signer app: " + e.getMessage(), e);
        }
        catch (ObjectCreationException e) {
            throw new SignatureException("Cannot create signer app: " + e.getMessage(), e);
        }
    }

    protected IArgs createSignerArgs() {
        return Args.create();
    }

    @Override
    protected Object engineGetParameter(String param) throws InvalidParameterException {
        return null;
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.cleanup();
        this.checkPrivateKey(privateKey);
        this.setPrivateKey((DevicePrivateKey)privateKey);
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void engineSetParameter(String param, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        ISigner tmpSigner = this.createSigner(this.getPrivateKey());
        try {
            this.checkSigner(tmpSigner);
            ((IAuthenticatedApplication)((Object)tmpSigner)).authenticate().get();
            IDigest digest = this.getDigester().digestFinal();
            ToBeSignedData tbs = ToBeSignedData.create((IDigest)digest);
            IConversation<ISignatureData> conversation = tmpSigner.sign((IToBeSignedData)tbs);
            byte[] byArray = ((ISignatureData)ConversationDriver.get().get(conversation)).getEncodedSignature();
            return byArray;
        }
        catch (ExecutionException e) {
            SecurityApplicationException cause = (SecurityApplicationException)ExceptionTools.unwrapTyped((Throwable)e, SecurityApplicationException.class);
            throw new SignatureException(e.getLocalizedMessage(), cause);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SignatureException(e.getLocalizedMessage(), e);
        }
        catch (Exception e) {
            throw new SignatureException(e.getLocalizedMessage(), e);
        }
        finally {
            tmpSigner.dispose();
            this.cleanup();
        }
    }

    @Override
    protected void engineUpdate(byte b) {
        try {
            this.getDigester().digestUpdate((InputStream)new ByteArrayInputStream(new byte[]{b}));
        }
        catch (IOException e) {
            throw new IllegalStateException("byte array input stream failed");
        }
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) {
        try {
            this.getDigester().digestUpdate((InputStream)new ByteArrayInputStream(b, off, len));
        }
        catch (IOException e) {
            throw new IllegalStateException("byte array input stream failed");
        }
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) {
        throw new UnsupportedOperationException();
    }

    protected IDigester getDigester() {
        return this.digester;
    }

    protected IDigester getInitialDigester() {
        return this.initialDigester;
    }

    public DevicePrivateKey getPrivateKey() {
        return this.privateKey;
    }

    protected void setDigester(IDigester digester) throws InvalidAlgorithmParameterException {
        this.digester = digester;
    }

    public void setPrivateKey(DevicePrivateKey privateKey) {
        this.privateKey = privateKey;
    }
}

