/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.pdf.signature;

import de.intarsys.pdf.cos.COSDocument;
import de.intarsys.pdf.cos.COSIndirectObject;
import de.intarsys.pdf.cos.COSTools;
import de.intarsys.pdf.crypt.ISystemSecurityHandler;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.signature.change.DefaultChange;
import de.intarsys.pdf.signature.history.HistoryTools;
import de.intarsys.security.method.pdf.signature.IDocumentChangeLog;
import de.intarsys.security.validation.IDocumentChange;
import de.intarsys.tools.collection.ListTools;
import de.intarsys.tools.locator.ILocator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentChangeLog
implements IDocumentChangeLog {
    private static final Logger Log = LoggerFactory.getLogger(DocumentChangeLog.class);
    private final PDDocument doc;
    private RevisionItem firstRevision;
    private RevisionItem finalRevision;

    protected static DocumentChangeLog basicCreate(PDDocument doc) throws IOException, COSLoadException {
        DocumentChangeLog documentChangeLog = new DocumentChangeLog(doc);
        documentChangeLog.initialize();
        return documentChangeLog;
    }

    public static IDocumentChangeLog create(PDDocument doc) {
        try {
            return DocumentChangeLog.basicCreate(doc);
        }
        catch (COSLoadException | IOException e) {
            Log.warn(e.getMessage(), e);
            return new IndeterminedDocumentChangeLog((Exception)e);
        }
    }

    public DocumentChangeLog(PDDocument doc) {
        this.doc = doc;
    }

    private void calculateRevisions() throws IOException, COSLoadException {
        List revisions = COSTools.getRevisions((COSDocument)this.getDoc().cosGetDoc());
        RevisionItem start = null;
        RevisionItem previous = null;
        RevisionItem current = null;
        for (COSTools.IRevision revision : revisions) {
            current = new RevisionItem(revision);
            if (start == null) {
                start = current;
            }
            if (previous != null) {
                previous.setNext(current);
                current.setPrevious(previous);
            }
            previous = current;
        }
        RevisionItem end = current;
        this.firstRevision = start;
        this.finalRevision = end;
    }

    @Override
    public List<IDocumentChange> getChangesAfter(COSTools.IRevision revision) throws IOException, COSLoadException {
        RevisionItem revisionItem = this.getRevisionItem(revision);
        if (revisionItem == null) {
            throw new IllegalStateException("unknown revision object");
        }
        ArrayList<IDocumentChange> changes = new ArrayList<IDocumentChange>();
        for (RevisionItem item = revisionItem.getNext(); item != null; item = item.getNext()) {
            if (Thread.currentThread().isInterrupted()) {
                throw new IOException("change collection interrupted");
            }
            List<IDocumentChange> itemChanges = item.getAssociatedChanges();
            changes.addAll(itemChanges);
        }
        return changes;
    }

    @Override
    public COSTools.IRevision getDefiningRevision(COSIndirectObject object) {
        int objectNumber = object.getKey().getObjectNumber();
        for (RevisionItem item = this.firstRevision; item != null; item = item.getNext()) {
            if (!item.value.definesObject(objectNumber)) continue;
            return item.value;
        }
        return null;
    }

    protected PDDocument getDoc() {
        return this.doc;
    }

    public RevisionItem getFinalRevision() {
        return this.finalRevision;
    }

    public RevisionItem getFirstRevision() {
        return this.firstRevision;
    }

    protected RevisionItem getRevisionItem(COSTools.IRevision revision) {
        for (RevisionItem item = this.firstRevision; item != null; item = item.getNext()) {
            if (item.value != revision) continue;
            return item;
        }
        return null;
    }

    private void initialize() throws IOException, COSLoadException {
        this.calculateRevisions();
    }

    private static class IndeterminedDocumentChangeLog
    implements IDocumentChangeLog {
        private Exception exception;

        public IndeterminedDocumentChangeLog(Exception exception) {
            this.exception = exception;
        }

        @Override
        public List<IDocumentChange> getChangesAfter(COSTools.IRevision revision) throws IOException, COSLoadException {
            return ListTools.with((Object[])new IDocumentChange[]{new DefaultChange(this.getException().getMessage())});
        }

        @Override
        public COSTools.IRevision getDefiningRevision(COSIndirectObject object) {
            return null;
        }

        public Exception getException() {
            return this.exception;
        }
    }

    public class RevisionItem {
        private COSTools.IRevision value;
        private RevisionItem previous;
        private RevisionItem next;
        private List<IDocumentChange> changes = null;

        public RevisionItem(COSTools.IRevision value) {
            this.value = value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected List<IDocumentChange> calculateAssociatedChanges() throws IOException, COSLoadException {
            if (this.getPrevious() == null) {
                return Collections.emptyList();
            }
            HashMap<String, ISystemSecurityHandler> options = new HashMap<String, ISystemSecurityHandler>();
            options.put("systemSecurityHandler", DocumentChangeLog.this.doc.cosGetDoc().stGetDoc().getReadSecurityHandler());
            try (COSDocument myDocument = COSDocument.createFromLocator((ILocator)this.getValue().createLocator(), options);){
                List<IDocumentChange> list = HistoryTools.generateHistory(myDocument, this.getPrevious().getValue());
                return list;
            }
        }

        public synchronized List<IDocumentChange> getAssociatedChanges() throws IOException, COSLoadException {
            if (this.changes == null) {
                this.changes = this.calculateAssociatedChanges();
            }
            return this.changes;
        }

        public RevisionItem getNext() {
            return this.next;
        }

        public RevisionItem getPrevious() {
            return this.previous;
        }

        public COSTools.IRevision getValue() {
            return this.value;
        }

        public void setNext(RevisionItem next) {
            this.next = next;
        }

        public void setPrevious(RevisionItem previous) {
            this.previous = previous;
        }
    }
}

