/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.template.model;

import de.intarsys.tools.expression.TaggedStringExpression;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.template.model.PACKAGE;
import de.intarsys.tools.template.model.TaggedStringPaletteExpression;
import de.intarsys.tools.template.model.TaggedStringPaletteNode;
import java.util.ArrayList;
import java.util.List;

public class TaggedStringPaletteContainer
extends TaggedStringPaletteNode {
    private static final String SQUARE_CLOSE = "]";
    private static final String SQUARE_OPEN = "[";
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private final List<TaggedStringPaletteNode> nodes = new ArrayList<TaggedStringPaletteNode>();
    private String id;

    public TaggedStringPaletteContainer(String id) {
        super(null, null);
        this.id = id;
    }

    public TaggedStringPaletteContainer(String id, String label) {
        super(null, label);
        this.id = id;
    }

    public TaggedStringPaletteContainer(TaggedStringPaletteContainer parent, String id) {
        super(parent, null);
        this.id = id;
    }

    public TaggedStringPaletteContainer(TaggedStringPaletteContainer parent, String id, String label) {
        super(parent, label);
        this.id = id;
    }

    public void addNode(TaggedStringPaletteNode node) {
        node.setParent(this);
        this.nodes.add(node);
    }

    @Override
    protected String createLabel() {
        String tempLabel = Msg.getPattern("TaggedStringPaletteContainer." + this.id);
        if (tempLabel == null) {
            return SQUARE_OPEN + this.id + SQUARE_CLOSE;
        }
        return SQUARE_OPEN + tempLabel + SQUARE_CLOSE;
    }

    public String getId() {
        return this.id;
    }

    public List<TaggedStringPaletteNode> getNodes() {
        return this.nodes;
    }

    public TaggedStringExpression lookupExpression(String name) {
        for (TaggedStringPaletteNode node : this.nodes) {
            if (!(node instanceof TaggedStringPaletteExpression) || !((TaggedStringPaletteExpression)node).getExpression().equals(name)) continue;
            return new TaggedStringExpression(((TaggedStringPaletteExpression)node).getExpression());
        }
        for (TaggedStringPaletteNode node : this.getNodes()) {
            TaggedStringExpression result;
            if (!(node instanceof TaggedStringPaletteContainer) || (result = ((TaggedStringPaletteContainer)node).lookupExpression(name)) == null) continue;
            return result;
        }
        return null;
    }

    public void removeNode(TaggedStringPaletteNode node) {
        if (this.nodes.remove(node)) {
            node.setParent(null);
        }
    }
}

