/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.tools;

import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;

public class X500NameTools {
    public static String getCN(X500Principal principal) {
        return X500NameTools.getComponentString(principal, BCStyle.CN);
    }

    public static String getComponentString(X500Name x500Name, ASN1ObjectIdentifier objectIdentifier) {
        RDN[] rdns = x500Name.getRDNs(objectIdentifier);
        if (rdns.length == 0) {
            return null;
        }
        RDN lastRdn = rdns[rdns.length - 1];
        for (AttributeTypeAndValue typeAndValue : lastRdn.getTypesAndValues()) {
            if (!objectIdentifier.equals((ASN1Primitive)typeAndValue.getType())) continue;
            return typeAndValue.getValue().toString();
        }
        return null;
    }

    public static String getComponentString(X500Principal principal, ASN1ObjectIdentifier objectIdentifier) {
        return X500NameTools.getComponentString(X500Name.getInstance((Object)principal.getEncoded()), objectIdentifier);
    }
}

