/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.standard.validation;

import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.info.X500PrincipalInfo;
import de.intarsys.security.validation.IVTCertificate;
import java.util.Date;

public class VTCertificate
implements IVTCertificate {
    private IX509Certificate certificate;

    public VTCertificate(IX509Certificate certificateImpl) {
        this.certificate = certificateImpl;
    }

    public IX509Certificate getCertificate() {
        return this.certificate;
    }

    @Override
    public String getCountry() {
        X500PrincipalInfo principal = this.getSubjectPrincipalInfo();
        if (principal == null) {
            return null;
        }
        return principal.getCountry();
    }

    @Override
    public String getEMail() {
        X500PrincipalInfo principal = this.getSubjectPrincipalInfo();
        if (principal == null) {
            return null;
        }
        return principal.getEMail();
    }

    @Override
    public String getGivenName() {
        X500PrincipalInfo principal = this.getSubjectPrincipalInfo();
        if (principal == null) {
            return null;
        }
        return principal.getGivenName();
    }

    @Override
    public Object getImpl() {
        return this.getCertificate();
    }

    @Override
    public String getIssuerCommonName() {
        X500PrincipalInfo principal = this.getIssuerPrincipalInfo();
        if (principal == null) {
            return "";
        }
        return principal.getCommonName();
    }

    @Override
    public String getIssuerName() {
        X500PrincipalInfo principal = this.getIssuerPrincipalInfo();
        if (principal == null) {
            return null;
        }
        return principal.getName();
    }

    public X500PrincipalInfo getIssuerPrincipalInfo() {
        if (this.getCertificate().getIssuerX500Principal() == null) {
            return null;
        }
        return new X500PrincipalInfo(this.getCertificate().getIssuerX500Principal());
    }

    @Override
    public String getLocality() {
        X500PrincipalInfo principal = this.getSubjectPrincipalInfo();
        if (principal == null) {
            return null;
        }
        return principal.getLocality();
    }

    @Override
    public String getOrganization() {
        X500PrincipalInfo principal = this.getSubjectPrincipalInfo();
        if (principal == null) {
            return null;
        }
        return principal.getOrganization();
    }

    @Override
    public String getOrganizationalUnit() {
        X500PrincipalInfo principal = this.getSubjectPrincipalInfo();
        if (principal == null) {
            return null;
        }
        return principal.getOrganizationalUnit();
    }

    @Override
    public String getPseudonym() {
        X500PrincipalInfo principal = this.getSubjectPrincipalInfo();
        if (principal == null) {
            return null;
        }
        return principal.getPseudonym();
    }

    @Override
    public String getState() {
        X500PrincipalInfo principal = this.getSubjectPrincipalInfo();
        if (principal == null) {
            return null;
        }
        return principal.getState();
    }

    @Override
    public String getSubjectCommonName() {
        X500PrincipalInfo principal = this.getSubjectPrincipalInfo();
        if (principal == null) {
            return "";
        }
        return principal.getCommonName();
    }

    @Override
    public String getSubjectName() {
        X500PrincipalInfo principal = this.getSubjectPrincipalInfo();
        if (principal == null) {
            return null;
        }
        return principal.getCommonName();
    }

    public X500PrincipalInfo getSubjectPrincipalInfo() {
        if (this.getCertificate().getSubjectX500Principal() == null) {
            return null;
        }
        return new X500PrincipalInfo(this.getCertificate().getSubjectX500Principal());
    }

    @Override
    public String getSurname() {
        X500PrincipalInfo principal = this.getSubjectPrincipalInfo();
        if (principal == null) {
            return null;
        }
        return principal.getSurname();
    }

    @Override
    public Date getValidFrom() {
        return this.certificate.getNotBefore();
    }

    @Override
    public Date getValidTo() {
        return this.certificate.getNotAfter();
    }
}

