/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.standard.validation;

import de.intarsys.security.standard.validation.ValidationMessage;
import de.intarsys.security.validation.IRecoverySupport;
import de.intarsys.security.validation.IValidationAspect;
import de.intarsys.security.validation.IValidationMessage;
import de.intarsys.security.validation.IValidationState;
import de.intarsys.security.validation.IValidationTarget;
import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.date.DateEnvironment;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.string.IPrettyPrintable;
import de.intarsys.tools.string.PrettyPrinter;
import de.intarsys.tools.string.StringTools;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public abstract class CommonValidationState
implements IValidationState,
IRecoverySupport,
IPrettyPrintable {
    private static final Logger Log = LoggerFactory.getLogger(CommonValidationState.class);
    private IValidationTarget validationTarget;
    private List<IValidationMessage> messages = new ArrayList<IValidationMessage>();
    private int state = -1;
    private Set<Object> additionalInfoObjects = new HashSet<Object>();
    private int severity = 0;
    private Date validationTime;
    private final AttributeMap attributes = new AttributeMap();
    private Map<String, IValidationAspect> aspects = new LinkedHashMap<String, IValidationAspect>();

    public static <T extends CommonValidationState> T castOrCopy(IValidationState state, Class<T> targetType) {
        if (targetType.isAssignableFrom(state.getClass())) {
            return (T)((CommonValidationState)state);
        }
        Optional<Constructor> constructor = Stream.of(targetType.getConstructors()).filter(op -> op.getParameterTypes().length == 1).filter(op -> op.getParameterTypes()[0].isAssignableFrom(state.getClass())).findAny();
        Exception cause = null;
        if (constructor.isPresent()) {
            try {
                return (T)((CommonValidationState)constructor.get().newInstance(state));
            }
            catch (Exception e) {
                cause = e;
            }
        }
        ClassCastException ex = new ClassCastException("Cannot cast or copy " + state.getClass().getName() + " to " + targetType.getName());
        if (cause != null) {
            ex.initCause(cause);
        }
        throw ex;
    }

    protected CommonValidationState() {
    }

    protected CommonValidationState(IValidationState state) {
        this.copy(state);
    }

    protected CommonValidationState(IValidationTarget validationTarget) {
        this.validationTarget = validationTarget;
        this.validationTime = DateEnvironment.get().now();
    }

    protected CommonValidationState(IValidationTarget validationTarget, int state) {
        this.setState(state);
        this.validationTarget = validationTarget;
        this.validationTime = DateEnvironment.get().now();
    }

    protected CommonValidationState(IValidationTarget validationTarget, IValidationState state) {
        this(state);
        this.setValidationTarget(validationTarget);
    }

    public void addAdditionalInfoObject(Object infoObject) {
        this.additionalInfoObjects.add(infoObject);
    }

    public void addAspect(IValidationAspect aspect) {
        this.aspects.put(aspect.getName(), aspect);
        this.increaseState(aspect.getState());
    }

    public void addMessage(IValidationMessage message) {
        this.messages.add(message);
    }

    public void addMessages(List<IValidationMessage> messages) {
        for (IValidationMessage message : messages) {
            this.addMessage(message);
        }
    }

    protected void copy(IValidationState state) {
        this.additionalInfoObjects = state.getAdditionalInfoObjects();
        this.messages = state.getMessages();
        this.validationTarget = state.getValidationTarget();
        this.state = state.getState();
        this.validationTime = state.getValidationTime();
        state.getAspects().stream().forEach(aspect -> this.addAspect((IValidationAspect)aspect));
        if (state instanceof CommonValidationState) {
            Arrays.stream(((CommonValidationState)state).attributes.getKeys()).forEach(key -> this.setAttribute(key, state.getAttribute(key)));
        }
    }

    @Override
    public Set<Object> getAdditionalInfoObjects() {
        return new HashSet<Object>(this.additionalInfoObjects);
    }

    @Override
    public IValidationAspect getAspect(String name) {
        return this.aspects.get(name);
    }

    @Override
    public List<IValidationAspect> getAspects() {
        return new ArrayList<IValidationAspect>(this.aspects.values());
    }

    public Object getAttribute(Object key) {
        return this.attributes.getAttribute(key);
    }

    public int getMessageCount() {
        return this.messages.size();
    }

    @Override
    public List<IValidationMessage> getMessages() {
        return new ArrayList<IValidationMessage>(this.messages);
    }

    @Override
    public int getSeverity() {
        return this.severity;
    }

    public String getSeverityLabel() {
        return IValidationState.getSeverityLabel(this.getSeverity());
    }

    @Override
    public int getState() {
        return this.state;
    }

    public String getStateLabel() {
        return IValidationState.getStateLabel(this.getState());
    }

    @Override
    public IValidationTarget getValidationTarget() {
        return this.validationTarget;
    }

    @Override
    public Date getValidationTime() {
        return this.validationTime;
    }

    public void increaseState(int newState) {
        if (newState > this.getState()) {
            this.setState(newState);
        }
    }

    public void increaseState(IValidationState state) {
        if (state == null) {
            return;
        }
        if (state.getSeverity() == 0) {
            this.increaseState(state.getState());
        }
    }

    protected String indent(String value) {
        try {
            StringBuilder sb = new StringBuilder();
            BufferedReader reader = new BufferedReader(new StringReader(value));
            String l = reader.readLine();
            while (l != null) {
                sb.append("   ").append(l).append(StringTools.LS);
                l = reader.readLine();
            }
            return sb.toString();
        }
        catch (IOException e) {
            return value;
        }
    }

    public void invalidate(IMessage errorMessage) {
        this.addMessage(ValidationMessage.createError(errorMessage));
        this.increaseState(3);
    }

    public void invalidate(IValidationMessage errorMessage) {
        this.addMessage(errorMessage);
        this.increaseState(3);
    }

    public void invalidate(String errorMessage) {
        this.addMessage(ValidationMessage.createError(errorMessage));
        this.increaseState(3);
    }

    @Override
    public boolean isInvalid() {
        return this.getState() == 3;
    }

    @Override
    public boolean isRecoverable() {
        return false;
    }

    protected boolean isRecoverable(IValidationState state) {
        if (this.isValidOrIgnorable(state)) {
            return true;
        }
        if (state instanceof IRecoverySupport) {
            return ((IRecoverySupport)((Object)state)).isRecoverable();
        }
        return false;
    }

    @Override
    public boolean isUndefined() {
        return this.getState() == -1;
    }

    @Override
    public boolean isUnknown() {
        return this.getState() == 2;
    }

    @Override
    public boolean isValid() {
        return this.getState() == 0;
    }

    protected boolean isValidOrIgnorable(IValidationState state) {
        return state == null || state.isUndefined() || state.isValid() || state.getSeverity() > 0;
    }

    public void merge(IValidationState toMerge) {
        this.increaseState(toMerge.getState());
        for (IValidationMessage message : toMerge.getMessages()) {
            this.addMessage(message);
        }
        for (Object infoObject : toMerge.getAdditionalInfoObjects()) {
            this.addAdditionalInfoObject(infoObject);
        }
    }

    public Object removeAttribute(Object key) {
        return this.attributes.removeAttribute(key);
    }

    public Object setAttribute(Object key, Object value) {
        return this.attributes.setAttribute(key, value);
    }

    public void setSeverity(int severity) {
        this.severity = severity;
    }

    public void setState(int state) {
        this.state = state;
        if (Log.isEnabledForLevel(Level.TRACE)) {
            String label = this.getClass().getSimpleName();
            String stateLabel = this.getStateLabel();
            Log.trace("{}: Set state to {} - {}", new Object[]{label, state, stateLabel});
        }
    }

    protected void setValidationTarget(IValidationTarget validationTarget) {
        this.validationTarget = validationTarget;
    }

    public String toString() {
        return new PrettyPrinter().toString((Object)this);
    }

    public void toString(PrettyPrinter printer) {
        printer.appendMember("state", (Object)this.getStateLabel(), null);
        printer.appendMember("severity", (Object)this.getSeverityLabel(), null);
        if (this.validationTarget != null) {
            printer.appendMember("validationTarget", (Object)this.getValidationTarget().getImpl().getClass().getName(), null);
        }
        if (this.messages.size() > 0) {
            printer.appendMember("messages", this.getMessages(), null);
        }
        if (this.aspects.size() > 0) {
            printer.appendMember("aspect", this.getAspects(), null);
        }
        if (this.additionalInfoObjects.size() > 0) {
            printer.appendMember("additionalInfos", this.getAdditionalInfoObjects(), null);
        }
    }
}

