/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.extension.common;

import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.extension.CommonX509ExtensionHandler;
import de.intarsys.security.extension.common.PACKAGE;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.ReasonFlags;

public class CRLDistributionPointsHandler
extends CommonX509ExtensionHandler {
    private static final IMessageBundle Msg = PACKAGE.Messages;

    @Override
    public String getLabel() {
        return Msg.getString("CRLDistributionPointsHandler.Label", new Object[0]);
    }

    @Override
    public String getOID() {
        return "2.5.29.31";
    }

    protected List getReasons(ReasonFlags flags) {
        ArrayList<String> result = new ArrayList<String>();
        int value = flags.intValue();
        if ((value & 0x8000) != 0) {
            result.add("aaCompromise");
        }
        if ((value & 0x10) != 0) {
            result.add("affiliationChanged");
        }
        if ((value & 0x20) != 0) {
            result.add("caCompromise");
        }
        if ((value & 2) != 0) {
            result.add("certificateHold");
        }
        if ((value & 4) != 0) {
            result.add("cessationOfOperation");
        }
        if ((value & 0x40) != 0) {
            result.add("keyCompromise");
        }
        if ((value & 1) != 0) {
            result.add("privilegeWithdrawn");
        }
        if ((value & 8) != 0) {
            result.add("superseded");
        }
        if ((value & 0x80) != 0) {
            result.add("unused");
        }
        return result;
    }

    @Override
    public String getStringValue(X509Extension object) throws IOException {
        ASN1Primitive value = CertificateTools.getExtensionValue(object, this.getOID());
        CRLDistPoint crlDistPoints = CRLDistPoint.getInstance((Object)value);
        if (crlDistPoints == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        DistributionPoint[] distPoints = crlDistPoints.getDistributionPoints();
        for (int i = 0; i < distPoints.length; ++i) {
            ReasonFlags reasons;
            X500Principal[] p;
            GeneralNames issuer;
            DistributionPoint crlDistPoint = distPoints[i];
            DistributionPointName dp_name = crlDistPoint.getDistributionPoint();
            if (dp_name.getType() == 0) {
                GeneralName[] generalNames = GeneralNames.getInstance((Object)dp_name.getName()).getNames();
                for (int j = 0; j < generalNames.length; ++j) {
                    if (generalNames[j].getTagNo() != 6) continue;
                    String url = ((DERIA5String)generalNames[j].getName()).getString();
                    sb.append("URL: ").append(url).append(StringTools.LS);
                }
            }
            if (crlDistPoint.getCRLIssuer() != null && (issuer = crlDistPoint.getCRLIssuer()) != null && (p = CertificateTools.parsePrincipals(issuer)) != null) {
                for (int j = 0; j < p.length; ++j) {
                    X500Principal principal = p[j];
                    sb.append("Issuer: ").append(principal.toString()).append(System.getProperty("line.separator"));
                }
            }
            if ((reasons = crlDistPoint.getReasons()) != null) {
                sb.append("Reasons: ");
                List reasonsList = this.getReasons(reasons);
                Iterator j = reasonsList.iterator();
                while (j.hasNext()) {
                    String r = (String)j.next();
                    sb.append(r);
                    if (!j.hasNext()) continue;
                    sb.append(", ");
                }
                sb.append(StringTools.LS);
            }
            sb.append(StringTools.LS);
        }
        return sb.toString();
    }
}

