/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.provider.keystore;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStoreSpi;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class X509KeyStoreSpi
extends KeyStoreSpi {
    private CertificateFactory cf;
    private Certificate certificate;
    private String alias;

    @Override
    public Enumeration<String> engineAliases() {
        return new Enumeration<String>(){
            boolean hasNext;
            {
                this.hasNext = X509KeyStoreSpi.this.alias != null;
            }

            @Override
            public boolean hasMoreElements() {
                return this.hasNext;
            }

            @Override
            public String nextElement() {
                if (this.hasNext) {
                    this.hasNext = false;
                    return X509KeyStoreSpi.this.alias;
                }
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        return this.alias != null && this.alias.equals(alias);
    }

    @Override
    public void engineDeleteEntry(String alias) {
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        if (alias == null || alias.equals(this.alias)) {
            return this.certificate;
        }
        return null;
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        if (cert.equals(this.certificate)) {
            return this.alias;
        }
        return null;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        Certificate cert = this.engineGetCertificate(alias);
        if (cert != null) {
            return new Certificate[]{cert};
        }
        return null;
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        return null;
    }

    @Override
    public Key engineGetKey(String alias, char[] password) {
        return null;
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        return this.engineContainsAlias(alias);
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        return false;
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException {
        if (stream == null) {
            return;
        }
        try {
            this.certificate = this.getCF().generateCertificate(stream);
        }
        catch (CertificateException e) {
            throw new IOException(e);
        }
        this.alias = this.certificate instanceof X509Certificate ? ((X509Certificate)this.certificate).getSubjectX500Principal().toString() : String.valueOf(System.currentTimeMillis());
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) {
        this.alias = alias;
        this.certificate = cert;
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) {
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) {
    }

    @Override
    public int engineSize() {
        return 1;
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException {
        try {
            stream.write(this.certificate.getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw new IOException(e);
        }
    }

    private CertificateFactory getCF() {
        if (this.cf == null) {
            try {
                this.cf = CertificateFactory.getInstance("X.509");
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
        }
        return this.cf;
    }
}

