/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.filter.standard;

import de.intarsys.security.certificate.filter.CertificateUsageFilter;
import de.intarsys.security.certificate.filter.IX509CertificateSelector;
import de.intarsys.security.certificate.filter.standard.X509CertificateSelector;
import de.intarsys.tools.encoding.Base64;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.x500.X500Principal;

public class X509CertificateSelectorSerializer {
    private static final String PATTERN_STRING_KEY_VALUE = "\\s*(\\w*)\\s*[:=]([^;]*);?";
    private static final String PATTERN_STRING_LIST = "\\s*\\[([^\\]]*)\\]";
    public static final String SERIALNUMBER = "serialnumber";
    public static final String SUBJECT = "subject";
    public static final String CERTIFICATE = "certificate";
    public static final String ISSUER = "issuer";
    public static final String ALIAS = "alias";
    public static final String USAGE = "usage";
    public static final String SEPARATOR = "=";
    public static final String DELIMITER = ";";
    private static final String LIST_START_CHAR = "[";
    private static final Pattern PATTERN_KEY_VALUE = Pattern.compile("\\s*(\\w*)\\s*[:=]([^;]*);?");
    private static final Pattern PATTERN_LIST = Pattern.compile("\\s*\\[([^\\]]*)\\]");

    public IX509CertificateSelector deserialize(String definition) throws IOException {
        X509CertificateSelector selector = new X509CertificateSelector();
        if (StringTools.isEmpty((String)definition)) {
            return selector;
        }
        boolean found = false;
        try {
            Matcher m = PATTERN_KEY_VALUE.matcher(definition);
            while (m.find()) {
                found = true;
                String key = m.group(1);
                String value = m.group(2);
                this.map(key, value, selector);
            }
        }
        catch (Exception e) {
            throw new IOException("parsing '" + definition + "' failed", e);
        }
        if (!found) {
            throw new IOException("parsing '" + definition + "' failed");
        }
        return selector;
    }

    public List<IX509CertificateSelector> deserializeList(String definitionList) throws IOException {
        if (StringTools.isEmpty((String)definitionList)) {
            return new ArrayList<IX509CertificateSelector>();
        }
        ArrayList<IX509CertificateSelector> result = new ArrayList<IX509CertificateSelector>();
        if (definitionList.trim().startsWith(LIST_START_CHAR)) {
            Matcher m = PATTERN_LIST.matcher(definitionList);
            while (m.find()) {
                String definition = m.group(1);
                if (StringTools.isEmpty((String)definition)) continue;
                result.add(this.deserialize(definition));
            }
        } else {
            result.add(this.deserialize(definitionList));
        }
        return result;
    }

    protected void map(String key, String value, X509CertificateSelector selector) throws IOException {
        if (StringTools.isEmpty((String)value)) {
            throw new IOException("key '" + key + "' value missing");
        }
        value = value.trim();
        if (ALIAS.equalsIgnoreCase(key)) {
            selector.setAlias(value);
        } else if (ISSUER.equalsIgnoreCase(key)) {
            selector.setIssuer(value);
        } else if (SUBJECT.equalsIgnoreCase(key)) {
            selector.setSubject(value);
        } else if (SERIALNUMBER.equalsIgnoreCase(key)) {
            BigInteger serial = new BigInteger(value);
            selector.setSerialNumber(serial);
        } else if (USAGE.equalsIgnoreCase(key)) {
            try {
                selector.setCertificateUsageFilter(CertificateUsageFilter.createFromName(value));
            }
            catch (ObjectCreationException e) {
                throw new IOException(e.getMessage());
            }
        } else if (CERTIFICATE.equalsIgnoreCase(key)) {
            try {
                selector.setCertificate(value);
            }
            catch (CertificateException e) {
                throw new IOException(e);
            }
        } else {
            throw new IOException("key '" + key + "' not supported");
        }
    }

    public String serialize(List<X509CertificateSelector> selectors) throws IOException {
        StringBuilder builder = new StringBuilder();
        for (X509CertificateSelector selector : selectors) {
            builder.append(LIST_START_CHAR);
            builder.append(this.serialize(selector));
            builder.append("]");
        }
        return builder.toString();
    }

    public String serialize(X509CertificateSelector selector) throws IOException {
        String alias;
        X509Certificate cert;
        CertificateUsageFilter usage;
        BigInteger serial;
        String value;
        StringBuilder builder = new StringBuilder();
        X500Principal principal = selector.getSubject();
        if (principal != null) {
            value = principal.toString();
            builder.append(SUBJECT);
            builder.append(SEPARATOR);
            builder.append(value);
            builder.append(DELIMITER);
        }
        if ((principal = selector.getIssuer()) != null) {
            value = principal.toString();
            builder.append(ISSUER);
            builder.append(SEPARATOR);
            builder.append(value);
            builder.append(DELIMITER);
        }
        if ((serial = selector.getSerialNumber()) != null) {
            value = serial.toString();
            builder.append(SERIALNUMBER);
            builder.append(SEPARATOR);
            builder.append(value);
            builder.append(DELIMITER);
        }
        if ((usage = selector.getCertificateUsageFilter()) != null) {
            value = usage.getName();
            builder.append(USAGE);
            builder.append(SEPARATOR);
            builder.append(value);
            builder.append(DELIMITER);
        }
        if ((cert = selector.getCertificate()) != null) {
            try {
                value = new String(Base64.encode((byte[])cert.getEncoded()));
            }
            catch (CertificateEncodingException e) {
                throw new IOException(e);
            }
            builder.append(CERTIFICATE);
            builder.append(SEPARATOR);
            builder.append(value);
            builder.append(DELIMITER);
        }
        if ((alias = selector.getAlias()) != null) {
            value = alias.toString();
            builder.append(ALIAS);
            builder.append(SEPARATOR);
            builder.append(value);
            builder.append(DELIMITER);
        }
        return builder.toString();
    }

    public String toJavaScript(String expr) throws IOException {
        StringBuilder sb = new StringBuilder();
        this.toJavaScript(expr, sb);
        return sb.toString();
    }

    protected void toJavaScript(String expr, StringBuilder sb) throws IOException {
        if (StringTools.isEmpty((String)expr)) {
            return;
        }
        if (expr.trim().startsWith(LIST_START_CHAR)) {
            Matcher m = PATTERN_LIST.matcher(expr);
            while (m.find()) {
                String term = m.group(1);
                if (StringTools.isEmpty((String)term)) continue;
                if (sb.length() > 0) {
                    sb.append(" || ");
                }
                this.toJavaScriptTerm(term, sb);
            }
        } else {
            this.toJavaScriptTerm(expr, sb);
        }
    }

    protected void toJavaScriptTerm(String key, String value, StringBuilder sb) throws IOException {
        if (StringTools.isEmpty((String)value)) {
            throw new IOException("key '" + key + "' value missing");
        }
        value = value.trim();
        if (ALIAS.equalsIgnoreCase(key)) {
            sb.append("principal.alias=='");
            sb.append(value);
            sb.append("'");
        } else if (ISSUER.equalsIgnoreCase(key)) {
            sb.append("principal.issuer=='");
            sb.append(value);
            sb.append("'");
        } else if (SUBJECT.equalsIgnoreCase(key)) {
            sb.append("principal.subject=='");
            sb.append(value);
            sb.append("'");
        } else if (SERIALNUMBER.equalsIgnoreCase(key)) {
            sb.append("principal.serialNumber=='");
            sb.append(value);
            sb.append("'");
        } else if (USAGE.equalsIgnoreCase(key)) {
            if ("authentication_and_encryption".equals(value)) {
                sb.append("(principal.supportsAuthentication || principal.supportsEncryption)");
            } else if ("encryption".equals(value)) {
                sb.append("principal.supportsEncryption");
            } else if ("signature".equals(value)) {
                sb.append("principal.supportsSignature");
            } else if ("signature_with_nonrepudiation".equals(value)) {
                sb.append("(principal.supportsSignature && principal.keyUsageNonRepudiation)");
            } else if ("qualified_signature".equals(value) || "signature_qualified".equals(value)) {
                sb.append("(principal.supportsSignature && principal.qualified)");
            } else if ("signature_without_nonrepudiation".equals(value)) {
                sb.append("(principal.supportsSignature && !principal.keyUsageNonRepudiation)");
            }
        } else if (CERTIFICATE.equalsIgnoreCase(key)) {
            sb.append("principal.certificateBase64=='");
            sb.append(value);
            sb.append("'");
        } else {
            throw new IOException("key '" + key + "' not supported");
        }
    }

    protected void toJavaScriptTerm(String term, StringBuilder sb) throws IOException {
        if (StringTools.isEmpty((String)term)) {
            return;
        }
        try {
            Matcher m = PATTERN_KEY_VALUE.matcher(term);
            boolean first = true;
            while (m.find()) {
                String key = m.group(1);
                String value = m.group(2);
                if (first) {
                    sb.append("(");
                    first = false;
                } else {
                    sb.append(" && ");
                }
                this.toJavaScriptTerm(key, value, sb);
            }
            if (!first) {
                sb.append(")");
            }
        }
        catch (Exception e) {
            throw new IOException("parsing '" + term + "' failed", e);
        }
    }
}

