/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.attribute;

import de.intarsys.asn1.common.Attribute;
import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.security.certificate.IX509Attribute;
import de.intarsys.security.certificate.attribute.PACKAGE;
import de.intarsys.tools.message.IMessageBundle;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;

public abstract class AbstractX509Attribute
implements IX509Attribute {
    protected static final IMessageBundle Msg = PACKAGE.Messages;
    private Attribute attribute;

    public AbstractX509Attribute(Attribute attribute) {
        this.attribute = attribute;
    }

    protected Attribute getAttribute() {
        return this.attribute;
    }

    @Override
    public String getType() {
        return this.attribute.getAttrType();
    }

    @Override
    public byte[] getValue(int index) throws IOException {
        ASN1ValueHolder o = this.attribute.getAttrValue(index);
        return ASN1Tools.toByteArray((ASN1Encodable[])new ASN1Encodable[]{o});
    }

    @Override
    public boolean isMultiValue() {
        return false;
    }

    @Override
    public boolean isSingleValue() {
        return false;
    }

    @Override
    public int size() {
        return this.attribute.size();
    }
}

