/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate;

import de.intarsys.security.certificate.ITrustBase;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.tools.adapter.AdapterTools;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.presentation.IPresentationSupport;
import de.intarsys.tools.string.IPrettyPrintable;
import de.intarsys.tools.string.PrettyPrinter;

public class TrustBaseTools {
    private static final Attribute ATTR_TRUSTBASE = new Attribute("trustBase");

    public static ITrustBase getTrustBase(ICertificateProvider certificateProvider) {
        ITrustBase trustBase = (ITrustBase)AdapterTools.getAdapter((Object)certificateProvider, ITrustBase.class, null);
        if (trustBase == null) {
            if (certificateProvider instanceof IAttributeSupport) {
                trustBase = (ITrustBase)((IAttributeSupport)certificateProvider).getAttribute((Object)ATTR_TRUSTBASE);
            }
            if (trustBase == null) {
                trustBase = new DefaultTrustBase(certificateProvider);
                TrustBaseTools.setTrustBase(certificateProvider, trustBase);
            }
        }
        return trustBase;
    }

    public static ITrustBase getTrustBase(IX509Certificate certificate) {
        ITrustBase trustBase = (ITrustBase)certificate.getAttribute(ATTR_TRUSTBASE);
        if (trustBase == null) {
            trustBase = TrustBaseTools.getTrustBase(certificate.getCertificateProvider());
        }
        return trustBase;
    }

    public static void setTrustBase(ICertificateProvider provider, ITrustBase trustBase) {
        if (provider instanceof IAttributeSupport) {
            ((IAttributeSupport)provider).setAttribute((Object)ATTR_TRUSTBASE, (Object)trustBase);
        }
    }

    public static void setTrustBase(IX509Certificate certificate, ITrustBase trustBase) {
        certificate.setAttribute(ATTR_TRUSTBASE, trustBase);
    }

    public static class DefaultTrustBase
    implements ITrustBase,
    IPrettyPrintable {
        private final ICertificateProvider certificateProvider;

        public DefaultTrustBase(ICertificateProvider certificateProvider) {
            this.certificateProvider = certificateProvider;
        }

        @Override
        public String getLabel() {
            if (this.certificateProvider instanceof IPresentationSupport) {
                return ((IPresentationSupport)this.certificateProvider).getLabel();
            }
            return "";
        }

        @Override
        public String getType() {
            return "";
        }

        public void toString(PrettyPrinter printer) {
            printer.appendMember("type", (Object)"DefaultTrustBase", null);
        }
    }
}

