/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.validation.commonpki;

import de.intarsys.security.app.validation.EnumKeyPurpose;
import de.intarsys.security.app.validation.ICertificateValidator;
import de.intarsys.security.app.validation.IValidationParameters;
import de.intarsys.security.app.validation.ValidationParameters;
import de.intarsys.security.app.validation.common.ValidationContext;
import de.intarsys.security.app.validation.commonpki.PACKAGE;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.standard.validation.CommonValidationMessages;
import de.intarsys.security.standard.validation.VSCertificate;
import de.intarsys.security.validation.IVSCertificate;
import de.intarsys.security.validation.IVSCertificatePath;
import de.intarsys.tools.message.IMessageBundle;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonPKICertificateValidator
implements ICertificateValidator {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private static final Logger Log = LoggerFactory.getLogger(CommonPKICertificateValidator.class);
    private static final String KEY_USAGE = "2.5.29.15";
    private static final String EXTENDED_KEY_USAGE = "2.5.29.37";
    private Deque processing = new ArrayDeque();

    protected IVSCertificate basicValidate(IX509Certificate certificate, IValidationParameters params) {
        if (certificate == null) {
            return null;
        }
        VSCertificate certState = new VSCertificate(certificate);
        params = this.increaseDepth(params);
        IVSCertificatePath pathState = this.validatePath(certificate, params);
        certState.setCertificatePathState(pathState);
        this.checkKeyPurpose(certificate, params.getKeyPurpose(), certState);
        return certState;
    }

    protected void checkExtendedKeyPurpose(IX509Certificate certificate, Set<KeyPurposeId> requiredKeyPurposes, VSCertificate state) {
        if (certificate.getType() == "AttributeCertificate") {
            return;
        }
        if (requiredKeyPurposes == null || requiredKeyPurposes.isEmpty()) {
            return;
        }
        ASN1Primitive derKeyUsage = null;
        try {
            derKeyUsage = CertificateTools.getExtensionValue(certificate, EXTENDED_KEY_USAGE);
        }
        catch (IOException e) {
            state.invalidate(CommonValidationMessages.ERROR_IO_EXTENSION(e, EXTENDED_KEY_USAGE));
            return;
        }
        if (derKeyUsage == null) {
            state.invalidate(CommonValidationMessages.ERROR_MISSING_EXTENSION(EXTENDED_KEY_USAGE));
            return;
        }
        ExtendedKeyUsage keyUsage = ExtendedKeyUsage.getInstance((Object)derKeyUsage);
        for (KeyPurposeId id : requiredKeyPurposes) {
            if (keyUsage.hasKeyPurposeId(id)) continue;
            state.invalidate(Msg.getString("CommonPKICertificateValidator.InvalidKeyUsage", new Object[0]));
            break;
        }
    }

    protected void checkKeyPurpose(IX509Certificate certificate, EnumKeyPurpose keyPurpose, VSCertificate state) {
        if (certificate.getType() == "AttributeCertificate") {
            return;
        }
        boolean requireKeyUsage = true;
        int acceptedKeyUsage = 0;
        HashSet<KeyPurposeId> requiredKeyPurposeIds = new HashSet<KeyPurposeId>();
        if (keyPurpose == EnumKeyPurpose.ANY) {
            return;
        }
        if (keyPurpose == EnumKeyPurpose.AUTHENTICATION) {
            acceptedKeyUsage = 128;
        } else if (keyPurpose == EnumKeyPurpose.CRL_SIGNING) {
            acceptedKeyUsage = 66;
        } else if (keyPurpose == EnumKeyPurpose.DIGITAL_SIGNATURE) {
            acceptedKeyUsage = 192;
        } else if (keyPurpose == EnumKeyPurpose.ENCRYPTION) {
            acceptedKeyUsage = 48;
        } else if (keyPurpose != EnumKeyPurpose.OCSP_SIGNING) {
            if (keyPurpose == EnumKeyPurpose.TIMESTAMPING) {
                acceptedKeyUsage = 192;
                requireKeyUsage = false;
                requiredKeyPurposeIds.add(KeyPurposeId.id_kp_timeStamping);
            } else if (keyPurpose == EnumKeyPurpose.CODESIGNING) {
                acceptedKeyUsage = 128;
                requiredKeyPurposeIds.add(KeyPurposeId.id_kp_codeSigning);
            } else if (keyPurpose == EnumKeyPurpose.SERVERAUTHENTICATION) {
                acceptedKeyUsage = 40;
                requireKeyUsage = false;
                requiredKeyPurposeIds.add(KeyPurposeId.id_kp_serverAuth);
            }
        }
        this.checkKeyPurpose(certificate, acceptedKeyUsage, requireKeyUsage, state);
        this.checkExtendedKeyPurpose(certificate, requiredKeyPurposeIds, state);
    }

    protected void checkKeyPurpose(IX509Certificate certificate, int acceptedKeyUsage, boolean requireKeyUsage, VSCertificate state) {
        if (certificate.getType() == "AttributeCertificate") {
            return;
        }
        if (acceptedKeyUsage == 0) {
            return;
        }
        ASN1Primitive derKeyUsage = null;
        try {
            derKeyUsage = CertificateTools.getExtensionValue(certificate, KEY_USAGE);
        }
        catch (IOException e) {
            state.invalidate(CommonValidationMessages.ERROR_IO_EXTENSION(e, KEY_USAGE));
            return;
        }
        if (derKeyUsage == null) {
            if (requireKeyUsage) {
                state.invalidate(CommonValidationMessages.ERROR_MISSING_EXTENSION(KEY_USAGE));
            }
            return;
        }
        DERBitString keyUsage = DERBitString.convert((ASN1BitString)ASN1BitString.getInstance((Object)derKeyUsage));
        if ((keyUsage.intValue() & acceptedKeyUsage) == 0) {
            state.invalidate(Msg.getString("CommonPKICertificateValidator.InvalidKeyUsage", new Object[0]));
        }
    }

    protected IValidationParameters increaseDepth(IValidationParameters params) {
        ValidationParameters newParams = ValidationParameters.copy(params);
        newParams.setDepth(params.getDepth() + 1);
        return newParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized IVSCertificate validate(IX509Certificate certificate, IValidationParameters params) {
        if (certificate == null) {
            return null;
        }
        if (this.processing.contains(certificate)) {
            VSCertificate state = new VSCertificate(certificate);
            state.increaseState(-1);
            Log.trace("Already validating certificate: " + CertificateTools.getSubjectLabel(certificate));
            return state;
        }
        this.processing.push(certificate);
        try {
            IVSCertificate iVSCertificate = this.basicValidate(certificate, params);
            return iVSCertificate;
        }
        finally {
            this.processing.pop();
        }
    }

    protected IVSCertificatePath validatePath(IX509Certificate certificate, IValidationParameters params) {
        ValidationParameters builderParams = ValidationParameters.copy(params);
        IVSCertificatePath pathState = ValidationContext.get().getCertificatePathBuilder().buildCertificatePath(certificate, builderParams);
        return pathState;
    }
}

