/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.validation;

import de.intarsys.security.algorithm.common.AlgorithmSpec;
import de.intarsys.security.app.validation.IDigestProvider;
import de.intarsys.tools.digest.IDigest;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;

public abstract class CachingDigestProvider
implements IDigestProvider {
    private final Map<AlgorithmSpec, IDigest> digestMap = new HashMap<AlgorithmSpec, IDigest>();

    protected abstract IDigest basicDigest(AlgorithmSpec var1) throws NoSuchAlgorithmException, IOException;

    @Override
    public final IDigest getDigest(AlgorithmSpec algorithmSpec) throws NoSuchAlgorithmException, IOException {
        IDigest digest = this.digestMap.get(algorithmSpec);
        if (digest == null) {
            if (algorithmSpec == null) {
                throw new IOException("no digest algorithm specified");
            }
            digest = this.basicDigest(algorithmSpec);
            this.digestMap.put(algorithmSpec, digest);
        }
        return digest;
    }
}

