/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.algorithm.common;

import de.intarsys.security.algorithm.common.Algorithm;
import de.intarsys.tools.string.StringTools;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DigestAlgorithm
extends Algorithm {
    private static final Map<String, DigestAlgorithm> algorithms = new HashMap<String, DigestAlgorithm>();
    public static final String NAME_MD2 = "MD2";
    public static final String NAME_MD4 = "MD4";
    public static final String NAME_MD5 = "MD5";
    public static final String NAME_SHA1 = "SHA-1";
    public static final String NAME_SHA224 = "SHA-224";
    public static final String NAME_SHA256 = "SHA-256";
    public static final String NAME_SHA384 = "SHA-384";
    public static final String NAME_SHA512 = "SHA-512";
    public static final String NAME_RIPEMD128 = "RIPEMD128";
    public static final String NAME_RIPEMD160 = "RIPEMD160";
    public static final String NAME_RIPEMD256 = "RIPEMD256";
    public static final String NAME_SHA3_224 = "SHA3-224";
    public static final String NAME_SHA3_256 = "SHA3-256";
    public static final String NAME_SHA3_384 = "SHA3-384";
    public static final String NAME_SHA3_512 = "SHA3-512";
    public static final String NAME_WHIRLPOOL = "WHIRLPOOL";
    public static final String NAME_UNDEFINED = "DigestAlgorithm.undefined";
    public static final String NAME_UNKNOWN = "DigestAlgorithm.unknown";
    public static final String OID_MD2 = "1.2.840.113549.2.2";
    public static final String OID_MD4 = "1.2.840.113549.2.4";
    public static final String OID_MD5 = "1.2.840.113549.2.5";
    public static final String OID_SHA1 = "1.3.14.3.2.26";
    public static final String OID_SHA224 = "2.16.840.1.101.3.4.2.4";
    public static final String OID_SHA256 = "2.16.840.1.101.3.4.2.1";
    public static final String OID_SHA384 = "2.16.840.1.101.3.4.2.2";
    public static final String OID_SHA512 = "2.16.840.1.101.3.4.2.3";
    public static final String OID_RIPEMD128 = "1.3.36.3.2.2";
    public static final String OID_RIPEMD160 = "1.3.36.3.2.1";
    public static final String OID_RIPEMD256 = "1.3.36.3.2.3";
    public static final String OID_SHA3_224 = "2.16.840.1.101.3.4.2.7";
    public static final String OID_SHA3_256 = "2.16.840.1.101.3.4.2.8";
    public static final String OID_SHA3_384 = "2.16.840.1.101.3.4.2.9";
    public static final String OID_SHA3_512 = "2.16.840.1.101.3.4.2.10";
    public static final String OID_WHIRLPOOL = "1.0.10118.3.0.55";
    public static final DigestAlgorithm ALG_MD2 = new DigestAlgorithm("MD2", "1.2.840.113549.2.2", 16, 10, null);
    public static final DigestAlgorithm ALG_MD4 = new DigestAlgorithm("MD4", "1.2.840.113549.2.4", 16, 11, null);
    public static final DigestAlgorithm ALG_MD5 = new DigestAlgorithm("MD5", "1.2.840.113549.2.5", 16, 12, null);
    public static final DigestAlgorithm ALG_SHA1 = new DigestAlgorithm("SHA-1", "1.3.14.3.2.26", 20, 10, null);
    public static final DigestAlgorithm ALG_SHA224 = new DigestAlgorithm("SHA-224", "2.16.840.1.101.3.4.2.4", 28, 30, null);
    public static final DigestAlgorithm ALG_SHA256 = new DigestAlgorithm("SHA-256", "2.16.840.1.101.3.4.2.1", 32, 50, null);
    public static final DigestAlgorithm ALG_SHA384 = new DigestAlgorithm("SHA-384", "2.16.840.1.101.3.4.2.2", 48, 60, null);
    public static final DigestAlgorithm ALG_SHA512 = new DigestAlgorithm("SHA-512", "2.16.840.1.101.3.4.2.3", 64, 70, null);
    public static final DigestAlgorithm ALG_RIPEMD128 = new DigestAlgorithm("RIPEMD128", "1.3.36.3.2.2", 16, 10, null);
    public static final DigestAlgorithm ALG_RIPEMD160 = new DigestAlgorithm("RIPEMD160", "1.3.36.3.2.1", 20, 20, null);
    public static final DigestAlgorithm ALG_RIPEMD256 = new DigestAlgorithm("RIPEMD256", "1.3.36.3.2.3", 32, 40, null);
    public static final DigestAlgorithm ALG_SHA3_224 = new DigestAlgorithm("SHA3-224", "2.16.840.1.101.3.4.2.7", 28, 30, null);
    public static final DigestAlgorithm ALG_SHA3_256 = new DigestAlgorithm("SHA3-256", "2.16.840.1.101.3.4.2.8", 32, 50, null);
    public static final DigestAlgorithm ALG_SHA3_384 = new DigestAlgorithm("SHA3-384", "2.16.840.1.101.3.4.2.9", 48, 60, null);
    public static final DigestAlgorithm ALG_SHA3_512 = new DigestAlgorithm("SHA3-512", "2.16.840.1.101.3.4.2.10", 64, 70, null);
    public static final DigestAlgorithm ALG_WHIRLPOOL = new DigestAlgorithm("WHIRLPOOL", "1.0.10118.3.0.55", 64, 60, null);
    public static final DigestAlgorithm ALG_UNDEFINED = new DigestAlgorithm("DigestAlgorithm.undefined", "DigestAlgorithm.undefined", 0, 0, null);
    public static final DigestAlgorithm ALG_UNKNOWN = new DigestAlgorithm("DigestAlgorithm.unknown", "DigestAlgorithm.unknown", 0, 0, null);
    private final int size;
    private final int strength;

    public static boolean contains(Collection<String> algorithmNames, String algorithmName) {
        DigestAlgorithm algorithm = DigestAlgorithm.lookupAlgorithmCanonical(algorithmName);
        if (algorithm == null) {
            return false;
        }
        for (String tempName : algorithmNames) {
            DigestAlgorithm tempAlgorithm = DigestAlgorithm.lookupAlgorithmCanonical(tempName);
            if (algorithm != tempAlgorithm) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(String algorithmNames, String algorithmName) {
        return DigestAlgorithm.contains(DigestAlgorithm.toList(algorithmNames), algorithmName);
    }

    public static List<Algorithm> getAlgorithms() {
        return new ArrayList<Algorithm>(algorithms.values());
    }

    public static DigestAlgorithm lookupAlgorithm(String name) {
        return algorithms.get(name);
    }

    public static DigestAlgorithm lookupAlgorithmCanonical(String name) {
        DigestAlgorithm result = algorithms.get(name);
        return result == null ? null : result.getCanonical();
    }

    public static String lookupAlgorithmName(String name) {
        DigestAlgorithm algo = algorithms.get(name);
        return algo == null ? null : algo.getCanonicalName();
    }

    public static List<String> lookupAlgorithmNames(String names) {
        ArrayList<String> result = new ArrayList<String>();
        List<DigestAlgorithm> tempAlgorithms = DigestAlgorithm.lookupAlgorithms(names);
        for (DigestAlgorithm tempAlgorithm : tempAlgorithms) {
            result.add(tempAlgorithm.getCanonicalName());
        }
        return result;
    }

    public static List<DigestAlgorithm> lookupAlgorithms(List<String> names) {
        if (names == null) {
            return Collections.emptyList();
        }
        ArrayList<DigestAlgorithm> result = new ArrayList<DigestAlgorithm>();
        for (String tempName : names) {
            DigestAlgorithm tempAlgorithm = DigestAlgorithm.lookupAlgorithm(tempName.trim());
            if (tempAlgorithm == null) continue;
            result.add(tempAlgorithm);
        }
        return result;
    }

    public static List<DigestAlgorithm> lookupAlgorithms(String names) {
        if (StringTools.isEmpty((String)names)) {
            return Collections.emptyList();
        }
        return DigestAlgorithm.lookupAlgorithms(DigestAlgorithm.toList(names));
    }

    public static String lookupOID(String name) {
        DigestAlgorithm algorithm = DigestAlgorithm.lookupAlgorithmCanonical(name);
        return algorithm == null ? null : algorithm.getOid();
    }

    protected static void register(DigestAlgorithm algorithm) {
        algorithms.put(algorithm.getName(), algorithm);
        algorithms.putIfAbsent(algorithm.getOid(), algorithm);
    }

    public static List<String> toList(String names) {
        if (StringTools.isEmpty((String)names)) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String name : names.split(",")) {
            if (StringTools.isEmpty((String)name)) continue;
            result.add(name.trim());
        }
        return result;
    }

    public DigestAlgorithm(String name, DigestAlgorithm aliased) {
        this(name, aliased.getOid(), aliased.getSize(), aliased.getStrength(), aliased);
    }

    public DigestAlgorithm(String name, String oid, int size, int strength, DigestAlgorithm canonical) {
        super(name, oid, canonical);
        this.size = size;
        this.strength = strength;
        DigestAlgorithm.register(this);
    }

    @Override
    public DigestAlgorithm getCanonical() {
        return (DigestAlgorithm)super.getCanonical();
    }

    public int getSize() {
        return this.size;
    }

    public int getStrength() {
        return this.strength;
    }

    static {
        new DigestAlgorithm("MD-2", ALG_MD2);
        new DigestAlgorithm("MD-4", ALG_MD4);
        new DigestAlgorithm("MD-5", ALG_MD5);
        new DigestAlgorithm("SHA1", ALG_SHA1);
        new DigestAlgorithm("SHA224", ALG_SHA224);
        new DigestAlgorithm("SHA256", ALG_SHA256);
        new DigestAlgorithm("SHA384", ALG_SHA384);
        new DigestAlgorithm("SHA512", ALG_SHA512);
        new DigestAlgorithm("RIPEMD-128", ALG_RIPEMD128);
        new DigestAlgorithm("RIPEMD-160", ALG_RIPEMD160);
        new DigestAlgorithm("RIPEMD-256", ALG_RIPEMD256);
    }
}

