/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.algorithm.common;

import de.intarsys.security.algorithm.common.Algorithm;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Objects;

public class AlgorithmSpec<T extends Algorithm> {
    private T algorithm;
    private AlgorithmParameterSpec parameterSpec;

    public AlgorithmSpec() {
    }

    public AlgorithmSpec(T algorithm) {
        this.setAlgorithm(algorithm);
    }

    public AlgorithmSpec(T algorithm, AlgorithmParameterSpec parameters) {
        this.setAlgorithm(algorithm);
        this.setParameterSpec(parameters);
    }

    public boolean equals(Object obj) {
        if (obj instanceof AlgorithmSpec) {
            return Objects.equals(this.algorithm, ((AlgorithmSpec)obj).algorithm);
        }
        return false;
    }

    public T getAlgorithm() {
        return this.algorithm;
    }

    public AlgorithmParameterSpec getParameterSpec() {
        return this.parameterSpec;
    }

    public int hashCode() {
        return Objects.hash(this.algorithm, this.parameterSpec);
    }

    public void setAlgorithm(T algorithm) {
        this.algorithm = algorithm;
    }

    public void setParameterSpec(AlgorithmParameterSpec parameters) {
        this.parameterSpec = parameters;
    }
}

