/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.stream;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class ConcatInputStream
extends InputStream {
    private final List inputs = new ArrayList();
    private InputStream current;
    private int index;

    public void addInput(InputStream input) {
        this.inputs.add(input);
        if (this.current == null) {
            this.current = input;
        }
    }

    @Override
    public void close() throws IOException {
        IOException ex = null;
        for (InputStream is : this.inputs) {
            try {
                is.close();
            }
            catch (IOException e) {
                ex = e;
            }
        }
        super.close();
        if (ex != null) {
            throw ex;
        }
    }

    @Override
    public int read() throws IOException {
        if (this.current == null) {
            return -1;
        }
        int result = this.current.read();
        if (result == -1) {
            ++this.index;
            this.current = this.index >= this.inputs.size() ? null : (InputStream)this.inputs.get(this.index);
            return this.read();
        }
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.current == null) {
            return -1;
        }
        int result = this.current.read(b, off, len);
        if (result == -1) {
            ++this.index;
            this.current = this.index >= this.inputs.size() ? null : (InputStream)this.inputs.get(this.index);
            return this.read(b, off, len);
        }
        return result;
    }
}

