/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.locator.CommonLocatorFactory;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorFactory;
import de.intarsys.tools.string.PrettyPrinter;
import java.io.IOException;

public class RelativeLocatorFactory
extends CommonLocatorFactory {
    private final ILocatorFactory locatorFactory;
    private final String path;
    private final ILocator locator;

    public RelativeLocatorFactory(ILocator locator) {
        this.locatorFactory = null;
        this.path = null;
        this.locator = locator;
    }

    public RelativeLocatorFactory(ILocatorFactory locatorFactory, String path) {
        this.locatorFactory = locatorFactory;
        path = ((String)path).replace("\\", "/");
        if (!((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        this.path = path;
        this.locator = null;
    }

    @Override
    protected ILocator basicCreateLocator(String location) throws IOException {
        if (this.locatorFactory != null) {
            return this.locatorFactory.createLocator(this.path + location);
        }
        return this.getLocator().getChild(location);
    }

    public ILocator getLocator() {
        return this.locator;
    }

    @Override
    public void toString(PrettyPrinter printer) {
        printer.appendMember("type", this.getClass().getName(), null);
        printer.appendMember("locatorFactory", this.locatorFactory, null);
        printer.appendMember("path", this.path, null);
        printer.appendMember("locator", this.locator, null);
    }
}

