/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.installresource;

import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.file.PathTools;
import de.intarsys.tools.stream.StreamTools;
import de.intarsys.tools.system.SystemTools;
import de.intarsys.tools.url.URLTools;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Install {
    private static String PlatformId;
    private static String PlatformFallbackId;
    private static String PlatformDefaultId;
    private static final Logger Log;
    private boolean platformDependent;
    protected final String name;
    protected final String path;
    protected File[] files;
    protected ClassLoader classLoader;

    protected static void copy(URL url, File file) throws IOException, FileNotFoundException {
        InputStream is = null;
        FileOutputStream os = null;
        try {
            is = url.openStream();
            os = new FileOutputStream(file);
            StreamTools.copy(is, os);
        }
        catch (IOException e) {
            try {
                throw new IOException("resource '" + url.getFile() + "' load error", e);
            }
            catch (Throwable throwable) {
                StreamTools.close(is);
                StreamTools.close(os);
                throw throwable;
            }
        }
        StreamTools.close(is);
        StreamTools.close(os);
    }

    protected static String createPlatformFallbackId() {
        String[] split = SystemTools.getOSName().split("\\s");
        return (split[0] + "-" + SystemTools.getOSArch()).toLowerCase();
    }

    protected static String createPlatformId() {
        return (SystemTools.getOSName() + "-" + SystemTools.getOSArch()).toLowerCase();
    }

    protected static void deleteOnExit(File file) {
        File[] children;
        if (file == null) {
            return;
        }
        if (file.isDirectory() && (children = file.listFiles()) != null) {
            for (int i = 0; i < children.length; ++i) {
                File child = children[i];
                Install.deleteOnExit(child);
            }
        }
        file.deleteOnExit();
    }

    public static String getPlatformDefaultId() {
        if (PlatformDefaultId == null) {
            return "default";
        }
        return PlatformDefaultId;
    }

    public static String getPlatformFallbackId() {
        if (PlatformFallbackId == null) {
            return Install.createPlatformFallbackId();
        }
        return PlatformFallbackId;
    }

    public static String getPlatformId() {
        if (PlatformId == null) {
            return Install.createPlatformId();
        }
        return PlatformId;
    }

    public static void setPlatformDefaultId(String value) {
        PlatformDefaultId = value;
    }

    public static void setPlatformFallbackId(String value) {
        PlatformFallbackId = value;
    }

    public static void setPlatformId(String value) {
        PlatformId = value;
    }

    protected Install(String path, String name, boolean platformDependent) {
        String tempPath = PathTools.withoutLeadingSeparator(path);
        this.path = tempPath = URLTools.withoutTrailingSeparator(tempPath);
        this.name = name;
        this.platformDependent = platformDependent;
    }

    public void delete() throws IOException {
        if (this.files == null) {
            return;
        }
        for (File file : this.files) {
            FileTools.deleteRecursivly(file);
        }
    }

    protected Iterator<URL> find(String name) {
        Iterator<URL> urls = null;
        try {
            String resourceName = null;
            if (this.isPlatformDependent()) {
                resourceName = this.getResourceNameFull(name);
                Log.trace("{} search platform dependent {}", this.getLogLabel(), (Object)resourceName);
                urls = this.open(resourceName);
                if (!urls.hasNext()) {
                    resourceName = this.getResourceNameFallback(name);
                    Log.trace("{} search platform dependent {}", this.getLogLabel(), (Object)resourceName);
                    urls = this.open(resourceName);
                    if (!urls.hasNext()) {
                        resourceName = this.getResourceNameDefault(name);
                        Log.trace("{} search platform dependent {}", this.getLogLabel(), (Object)resourceName);
                        urls = this.open(resourceName);
                    }
                }
            } else {
                resourceName = this.getResourceNamePlain(name);
                Log.trace("{} search {}", this.getLogLabel(), (Object)resourceName);
                urls = this.open(resourceName);
            }
        }
        catch (Exception e) {
            urls = Collections.emptyIterator();
        }
        return urls;
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            ClassLoader result = Thread.currentThread().getContextClassLoader();
            if (result == null) {
                result = this.getClass().getClassLoader();
            }
            return result;
        }
        return this.classLoader;
    }

    public File getFile() {
        if (this.files == null || this.files.length == 0) {
            return null;
        }
        return this.files[0];
    }

    public File[] getFiles() {
        return this.files;
    }

    protected Object getLogLabel() {
        return this.getClass().getName() + " " + this.getPath() + ", " + this.getName();
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    protected String getResourceNameDefault(String name) {
        return Install.getPlatformDefaultId() + "/" + name;
    }

    protected String getResourceNameFallback(String name) {
        return Install.getPlatformFallbackId() + "/" + name;
    }

    protected String getResourceNameFull(String name) {
        return Install.getPlatformId() + "/" + name;
    }

    protected String getResourceNamePlain(String name) {
        return name;
    }

    public boolean isPlatformDependent() {
        return this.platformDependent;
    }

    public File load() throws IOException {
        Log.trace("{} load", this.getLogLabel());
        Iterator<URL> urls = this.find(this.getName());
        if (urls.hasNext()) {
            URL url = urls.next();
            try {
                Log.trace("{} load resource {}", this.getLogLabel(), (Object)url);
                File file = this.loadURL(url);
                Install.deleteOnExit(file);
                this.files = new File[]{file};
                return file;
            }
            catch (IOException e) {
                Log.trace("{} load resource {} failed ({})", new Object[]{this.getLogLabel(), url, ExceptionTools.getMessage(e)});
                throw e;
            }
        }
        return null;
    }

    public File[] loadAll() throws IOException {
        Log.trace("{} loadAll", this.getLogLabel());
        ArrayList<File> tempFiles = new ArrayList<File>();
        Iterator<URL> urls = this.find(this.getName());
        while (urls.hasNext()) {
            URL url = urls.next();
            try {
                Log.trace("{} loadAll resource {}", this.getLogLabel(), (Object)url);
                File file = this.loadURL(url);
                Install.deleteOnExit(file);
                tempFiles.add(file);
            }
            catch (Exception e) {
                Log.trace("{} loadAll resource {} failed ({})", new Object[]{this.getLogLabel(), url, ExceptionTools.getMessage(e)});
                throw e;
            }
        }
        this.files = tempFiles.toArray(new File[tempFiles.size()]);
        return this.files;
    }

    protected abstract File loadURL(URL var1) throws IOException;

    protected Iterator<URL> open(String name) throws IOException {
        String resourceName = this.prefix(name);
        Enumeration<URL> urls = this.getClassLoader().getResources(resourceName);
        if (urls.hasMoreElements()) {
            HashSet<URL> urlSet = new HashSet<URL>();
            urlSet.addAll(Collections.list(urls));
            return urlSet.iterator();
        }
        return Collections.emptyIterator();
    }

    protected String prefix(String name) {
        StringBuilder sb = new StringBuilder();
        if (this.getPath() != null) {
            sb.append(this.getPath());
            if (sb.length() > 0) {
                sb.append("/");
            }
        }
        sb.append(name);
        return sb.toString();
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    static {
        Log = LoggerFactory.getLogger(Install.class);
    }
}

