/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.infoset;

import de.intarsys.tools.infoset.ElementFactory;
import de.intarsys.tools.infoset.IDocument;
import de.intarsys.tools.infoset.IElement;

public class DocumentBuilder {
    private final DocumentBuilder parent;
    private final IDocument document;
    private final IElement current;

    public DocumentBuilder() {
        this.parent = null;
        this.document = ElementFactory.get().createDocument();
        this.current = ElementFactory.get().createElement("root");
        this.document.setRootElement(this.current);
    }

    protected DocumentBuilder(DocumentBuilder parent, IElement current) {
        this.parent = parent;
        this.document = parent.getDocument();
        this.current = current;
    }

    public DocumentBuilder(IDocument document) {
        this.parent = null;
        this.document = document;
        this.current = document.getRootElement();
    }

    public DocumentBuilder(IDocument document, IElement element) {
        this.parent = null;
        this.document = document;
        this.current = element;
    }

    public DocumentBuilder attributeData(String name, Object value) {
        this.current.setAttributeData(name, value);
        return this;
    }

    public DocumentBuilder attributeValue(String name, String value) {
        this.current.setAttributeValue(name, value);
        return this;
    }

    public DocumentBuilder element(String name) {
        IElement child = this.current.element(name);
        if (child == null) {
            child = this.current.newElementMapped(name);
        }
        return new DocumentBuilder(this, child);
    }

    public DocumentBuilder end() {
        return this.parent;
    }

    public IElement getCurrentElement() {
        return this.current;
    }

    public IDocument getDocument() {
        return this.document;
    }

    public IElement getRootElement() {
        return this.document.getRootElement();
    }

    public DocumentBuilder setName(String name) {
        this.current.setName(name);
        return this;
    }

    public DocumentBuilder setText(String value) {
        this.current.setText(value);
        return this;
    }
}

