/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.file;

import de.intarsys.tools.file.FileTools;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TempTools {
    private static volatile File TempDir;
    private static volatile File TempDirVM;
    private static AtomicInteger FileCounter;
    private static AtomicInteger DirCounter;
    private static final Logger Log;

    protected static void cleanUp() {
        File root = TempTools.getTempDir();
        TempTools.cleanUp(root);
    }

    protected static void cleanUp(File root) {
        File[] files = root.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() && file.getName().startsWith(TempTools.class.getName());
            }
        });
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            TempTools.cleanUpTempDir(files[i]);
        }
    }

    protected static void cleanUpTempDir(File file) {
        FileTools.Lock tempLock = FileTools.lock(file);
        if (tempLock == null) {
            return;
        }
        tempLock.release();
        try {
            FileTools.deleteRecursivly(file);
        }
        catch (IOException e) {
            Log.warn("failed to cleanup temp dir {}", (Object)file, (Object)e);
        }
    }

    public static synchronized File createTempDir(String prefix, String suffix) {
        String tempName = prefix + DirCounter.getAndIncrement() + suffix;
        File tempFile = new File(TempTools.getTempDirVM(), tempName);
        try {
            FileTools.mkdirs(tempFile);
            return tempFile;
        }
        catch (IOException e) {
            Log.warn("failed to create dir " + tempFile.getAbsolutePath(), (Throwable)e);
            return TempTools.getTempDir();
        }
    }

    protected static File createTempDirVM(File parent) {
        String name = TempTools.class.getName();
        File tempFile = new File(parent, name);
        int counter = 0;
        while (true) {
            FileTools.Lock lock;
            tempFile = new File(parent, name + "_" + counter);
            Log.trace("create temp directory,  check {}", (Object)tempFile);
            if (!tempFile.exists() && tempFile.mkdirs() && (lock = FileTools.lock(tempFile)) != null) break;
            ++counter;
        }
        Log.trace("create temp directory,  lock {}", (Object)tempFile);
        return tempFile;
    }

    public static synchronized File createTempFile(String prefix, String suffix) {
        String tempName = prefix + suffix;
        File tempFile = new File(TempTools.getTempDirVM(), tempName);
        if (tempFile.exists()) {
            tempName = prefix + FileCounter.getAndIncrement() + suffix;
            tempFile = new File(TempTools.getTempDirVM(), tempName);
        }
        return tempFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File getTempDir() {
        File result = TempDir;
        if (result != null) return result;
        Class<TempTools> clazz = TempTools.class;
        synchronized (TempTools.class) {
            result = TempDir;
            if (result != null) return result;
            TempDir = result = new File(System.getProperty("java.io.tmpdir"));
            TempTools.cleanUp();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File getTempDirVM() {
        File result = TempDirVM;
        if (result != null) return result;
        Class<TempTools> clazz = TempTools.class;
        synchronized (TempTools.class) {
            result = TempDirVM;
            if (result != null) return result;
            TempDirVM = result = TempTools.createTempDirVM(TempTools.getTempDir());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTempDir(File pTempDir) {
        Class<TempTools> clazz = TempTools.class;
        synchronized (TempTools.class) {
            TempDir = pTempDir;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            TempTools.cleanUp();
            return;
        }
    }

    private TempTools() {
    }

    static {
        FileCounter = new AtomicInteger(0);
        DirCounter = new AtomicInteger(0);
        Log = LoggerFactory.getLogger(TempTools.class);
    }
}

