/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.file;

import de.intarsys.tools.stream.StreamTools;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class FileSnapshot {
    private static final Logger Log = LoggerFactory.getLogger(FileSnapshot.class);
    private final File file;
    private List<FileSnapshot> children;
    private boolean logged = false;
    private long fileLength;
    private long lastModified;

    public FileSnapshot(File file) {
        this.file = file;
        long newLastModified = this.getFile().lastModified();
        long newLength = this.getFile().length();
        if (Log.isEnabledForLevel(Level.TRACE)) {
            Log.trace("snapshot of " + this.getFile().getAbsolutePath());
        }
        this.updateLocal(newLength, newLastModified);
        File[] tempFiles = file.listFiles();
        if (tempFiles != null) {
            this.updateChildren(Arrays.asList(tempFiles));
        }
    }

    public FileSnapshot[] getChildren() {
        if (this.children == null) {
            return new FileSnapshot[0];
        }
        return this.children.toArray(new FileSnapshot[this.children.size()]);
    }

    public File getFile() {
        return this.file;
    }

    public long getFileLength() {
        return this.fileLength;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isAvailable() {
        block23: {
            FileLock lock;
            FileOutputStream os;
            block21: {
                boolean bl;
                block22: {
                    if (this.children != null) {
                        for (FileSnapshot child : this.children) {
                            if (child.isAvailable()) continue;
                            if (Log.isEnabledForLevel(Level.TRACE)) {
                                Log.trace("snapshot not available " + this.getFile().getAbsolutePath());
                            }
                            return false;
                        }
                        if (Log.isEnabledForLevel(Level.TRACE)) {
                            Log.trace("snapshot available " + this.getFile().getAbsolutePath());
                        }
                        return true;
                    }
                    if (!this.getFile().exists()) {
                        if (Log.isEnabledForLevel(Level.TRACE)) {
                            Log.trace("snapshot available " + this.getFile().getAbsolutePath());
                        }
                        return true;
                    }
                    os = null;
                    lock = null;
                    try {
                        os = new FileOutputStream(this.getFile(), true);
                        lock = os.getChannel().tryLock();
                        if (lock == null) break block21;
                        if (Log.isEnabledForLevel(Level.TRACE)) {
                            Log.trace("snapshot available " + this.getFile().getAbsolutePath());
                        }
                        bl = true;
                        if (lock == null) break block22;
                    }
                    catch (Exception exception) {
                        if (lock != null) {
                            try {
                                lock.release();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        StreamTools.close(os);
                        break block23;
                    }
                    catch (Throwable throwable) {
                        if (lock != null) {
                            try {
                                lock.release();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        StreamTools.close(os);
                        throw throwable;
                    }
                    try {
                        lock.release();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                StreamTools.close(os);
                return bl;
            }
            if (lock != null) {
                try {
                    lock.release();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            StreamTools.close(os);
        }
        Level level = this.logged ? Level.TRACE : Level.INFO;
        this.logged = true;
        Log.atLevel(level).log("snapshot not available " + this.getFile().getAbsolutePath());
        return false;
    }

    public boolean isChanged() {
        long newLastModified = this.getFile().lastModified();
        long newLength = this.getFile().length();
        File[] tempFiles = this.getFile().listFiles();
        ArrayList<File> newFiles = tempFiles == null ? Collections.emptyList() : new ArrayList<File>(Arrays.asList(tempFiles));
        boolean changed = false;
        boolean exists = this.getFile().exists();
        if (!exists) {
            this.children = null;
            changed = true;
        }
        if (this.children != null) {
            Iterator<FileSnapshot> it = this.children.iterator();
            while (it.hasNext()) {
                FileSnapshot child = it.next();
                if (child.isChanged()) {
                    changed = true;
                    if (child.isLost()) {
                        it.remove();
                    }
                }
                newFiles.remove(child.getFile());
            }
        }
        if (!newFiles.isEmpty()) {
            this.updateChildren(newFiles);
            changed = true;
        }
        if (newLastModified != this.lastModified || newLength != this.fileLength) {
            this.updateLocal(newLength, newLastModified);
            changed = true;
        }
        if (Log.isEnabledForLevel(Level.TRACE)) {
            if (changed) {
                Log.trace("snapshot changed " + this.getFile().getAbsolutePath());
            } else {
                Log.trace("snapshot unchanged " + this.getFile().getAbsolutePath());
            }
        }
        return changed;
    }

    public boolean isLost() {
        return !this.getFile().exists();
    }

    public String toString() {
        return this.file.toString();
    }

    protected void updateChildren(List<File> files) {
        if (this.children == null) {
            this.children = new ArrayList<FileSnapshot>();
        }
        for (File newFile : files) {
            this.children.add(new FileSnapshot(newFile));
        }
    }

    protected void updateLocal(long newLength, long newModified) {
        this.fileLength = newLength;
        this.lastModified = newModified;
    }
}

