/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.expression;

import de.intarsys.tools.component.Singleton;
import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.LazyTemplateEvaluator;
import de.intarsys.tools.expression.Mode;
import de.intarsys.tools.expression.StringEvaluatorTools;
import de.intarsys.tools.expression.TaggedStringEvaluator;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import jakarta.annotation.PostConstruct;
import java.util.EnumMap;
import java.util.Map;

@Singleton
public final class TemplateEvaluator {
    private static final Map<Mode, IStringEvaluator> EVALUATORS = new EnumMap<Mode, IStringEvaluator>(Mode.class);

    public static String evaluateString(Mode mode, String value) {
        return TemplateEvaluator.evaluateString(mode, value, Args.create());
    }

    public static String evaluateString(Mode mode, String value, IArgs args) {
        return StringEvaluatorTools.evaluateString(TemplateEvaluator.get(mode), value, args);
    }

    @Deprecated(since="4.23.0", forRemoval=true)
    public static String evaluateString(String value) {
        return TemplateEvaluator.evaluateString(value, Args.create());
    }

    @Deprecated(since="4.23.0", forRemoval=true)
    public static String evaluateString(String value, IArgs args) {
        return StringEvaluatorTools.evaluateString(TemplateEvaluator.get(), value, args);
    }

    @Deprecated(since="4.23.0", forRemoval=true)
    public static IStringEvaluator get() {
        return TemplateEvaluator.get(Mode.UNTRUSTED);
    }

    public static IStringEvaluator get(Mode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("mode must not be null");
        }
        return EVALUATORS.computeIfAbsent(mode, LazyTemplateEvaluator::new);
    }

    @Deprecated(since="4.23.0", forRemoval=true)
    public static void set(IStringEvaluator evaluator) {
        TemplateEvaluator.set(Mode.UNTRUSTED, evaluator);
    }

    public static void set(Mode mode, IStringEvaluator evaluator) {
        if (mode == null) {
            throw new IllegalArgumentException("mode must not be null");
        }
        if (evaluator == null) {
            throw new IllegalArgumentException("evaluator must not be null");
        }
        EVALUATORS.put(mode, evaluator);
    }

    public static String translate(String template, final Map<String, String> expressionMap) {
        IStringEvaluator resolver = new IStringEvaluator(){

            @Override
            public Object evaluate(String expression, IArgs args) throws EvaluationException {
                String[] instructions = expression.split(":", 2);
                String valueExpression = instructions[0].trim();
                Object replacement = (String)expressionMap.get(valueExpression);
                if (replacement == null) {
                    replacement = expression;
                } else if (instructions.length > 1) {
                    replacement = (String)replacement + ":" + instructions[1];
                }
                return "${" + (String)replacement + "}";
            }
        };
        TaggedStringEvaluator evaluator = new TaggedStringEvaluator(resolver);
        return StringEvaluatorTools.evaluateString(evaluator, template);
    }

    private TemplateEvaluator() {
    }

    public static class Installer {
        private Mode mode;
        private IStringEvaluator resolver;

        public Installer(Mode mode, IStringEvaluator resolver) {
            this.mode = mode;
            this.resolver = resolver;
        }

        @PostConstruct
        public void install() {
            TemplateEvaluator.set(this.mode, TaggedStringEvaluator.decorate(this.resolver));
        }
    }
}

